/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.NetconfOperationCompleter;
import org.onosproject.cli.net.OpticalConnectPointCompleter;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.Direction;
import org.onosproject.net.Port;
import org.onosproject.net.behaviour.PowerConfig;
import org.onosproject.net.device.DeviceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Command(scope="onos", name="power-config", description="Get/Edit the target-output-power for specific optical-channel")
public class PowerConfigCommand
extends AbstractShellCommand {
    private static final Logger log = LoggerFactory.getLogger(PowerConfigCommand.class);
    @Argument(index=0, name="operation", description="Netconf Operation including get, edit-config, etc.", required=true, multiValued=false)
    @Completion(value=NetconfOperationCompleter.class)
    private String operation = null;
    @Argument(index=1, name="connection point", description="{DeviceID}/{PortNumber}", required=true, multiValued=false)
    @Completion(value=OpticalConnectPointCompleter.class)
    private String connectPoint = null;
    @Argument(index=2, name="value", description="target-output-power value. Unit: dBm", required=false, multiValued=false)
    private Long value = null;

    @Override
    protected void doExecute() throws Exception {
        ConnectPoint cp;
        DeviceService deviceService = PowerConfigCommand.get(DeviceService.class);
        Port port = deviceService.getPort(cp = ConnectPoint.deviceConnectPoint((String)this.connectPoint));
        if (port == null) {
            this.print("[ERROR] %s does not exist", cp);
            return;
        }
        if (!(port.type().equals((Object)Port.Type.OCH) || port.type().equals((Object)Port.Type.OTU) || port.type().equals((Object)Port.Type.OMS))) {
            log.warn("The power of selected port %s isn't editable.", (Object)port.number().toString());
            this.print("The power of selected port %s isn't editable.", port.number().toString());
            return;
        }
        Device device = deviceService.getDevice(cp.deviceId());
        PowerConfig powerConfig = (PowerConfig)device.as(PowerConfig.class);
        if (this.operation.equals("get")) {
            Optional val = powerConfig.getTargetPower(cp.port(), (Object)Direction.ALL);
            long power = val.isPresent() ? (Long)val.get() : Long.MIN_VALUE;
            this.print("The target-output-power value in port %s on device %s is %d.", cp.port().toString(), cp.deviceId().toString(), power);
        } else if (this.operation.equals("edit-config")) {
            Preconditions.checkNotNull((Object)this.value);
            powerConfig.setTargetPower(cp.port(), (Object)Direction.ALL, this.value.longValue());
        } else {
            log.warn("Operation {} are not supported now.", (Object)this.operation);
        }
    }
}

