/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.util.concurrent.Futures;
import java.util.concurrent.Future;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.NodeIdCompleter;
import org.onosproject.cli.net.DeviceIdCompleter;
import org.onosproject.cli.net.RoleCompleter;
import org.onosproject.cluster.NodeId;
import org.onosproject.mastership.MastershipAdminService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;

@Service
@Command(scope="onos", name="device-role", description="Sets role of the controller node for the given infrastructure device")
public class DeviceRoleCommand
extends AbstractShellCommand {
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    @Completion(value=DeviceIdCompleter.class)
    String uri = null;
    @Argument(index=1, name="node", description="Node ID", required=true, multiValued=false)
    @Completion(value=NodeIdCompleter.class)
    String node = null;
    @Argument(index=2, name="role", description="Mastership role", required=true, multiValued=false)
    @Completion(value=RoleCompleter.class)
    String role = null;

    @Override
    protected void doExecute() {
        MastershipAdminService service = DeviceRoleCommand.get(MastershipAdminService.class);
        MastershipRole mastershipRole = MastershipRole.valueOf((String)this.role.toUpperCase());
        Futures.getUnchecked((Future)service.setRole(new NodeId(this.node), DeviceId.deviceId((String)this.uri), mastershipRole));
    }
}

