/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.NullCompleter;
import org.onlab.packet.Ethernet;
import org.onlab.packet.MacAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.ConnectPointCompleter;
import org.onosproject.core.ApplicationId;
import org.onosproject.event.EventListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.PointToPointIntent;

@Service
@Command(scope="onos", name="push-test-intents", description="Installs random intents to test throughput")
public class IntentPushTestCommand
extends AbstractShellCommand
implements IntentListener {
    @Argument(index=0, name="ingressDevice", description="Ingress Device/Port Description", required=true, multiValued=false)
    @Completion(value=ConnectPointCompleter.class)
    String ingressDeviceString = null;
    @Argument(index=1, name="egressDevice", description="Egress Device/Port Description", required=true, multiValued=false)
    @Completion(value=ConnectPointCompleter.class)
    String egressDeviceString = null;
    @Argument(index=2, name="numberOfIntents", description="Number of intents to install/withdraw", required=true, multiValued=false)
    @Completion(value=NullCompleter.class)
    String numberOfIntents = null;
    @Argument(index=3, name="keyOffset", description="Starting point for first key (default: 1)", required=false, multiValued=false)
    String keyOffsetStr = null;
    @Option(name="-i", aliases={"--install"}, description="Install intents", required=false, multiValued=false)
    private boolean installOnly = false;
    @Option(name="-w", aliases={"--withdraw"}, description="Withdraw intents", required=false, multiValued=false)
    private boolean withdrawOnly = false;
    private IntentService service;
    private CountDownLatch latch;
    private volatile long start;
    private volatile long end;
    private int count;
    private int keyOffset;
    private boolean add;
    List<Key> keysForInstall = new ArrayList<Key>();
    List<Key> keysForWithdraw = new ArrayList<Key>();
    private static final EnumSet<IntentEvent.Type> IGNORE_EVENT = EnumSet.of(IntentEvent.Type.INSTALL_REQ, IntentEvent.Type.WITHDRAW_REQ);

    @Override
    protected void doExecute() {
        boolean both;
        this.service = IntentPushTestCommand.get(IntentService.class);
        DeviceId ingressDeviceId = DeviceId.deviceId((String)this.getDeviceId(this.ingressDeviceString));
        PortNumber ingressPortNumber = PortNumber.portNumber((String)this.getPortNumber(this.ingressDeviceString));
        ConnectPoint ingress = new ConnectPoint((ElementId)ingressDeviceId, ingressPortNumber);
        DeviceId egressDeviceId = DeviceId.deviceId((String)this.getDeviceId(this.egressDeviceString));
        PortNumber egressPortNumber = PortNumber.portNumber((String)this.getPortNumber(this.egressDeviceString));
        ConnectPoint egress = new ConnectPoint((ElementId)egressDeviceId, egressPortNumber);
        this.count = Integer.parseInt(this.numberOfIntents);
        this.keyOffset = this.keyOffsetStr != null ? Integer.parseInt(this.keyOffsetStr) : 1;
        this.service.addListener((EventListener)this);
        List<Intent> operations = this.generateIntents(ingress, egress);
        boolean bl = both = !(this.installOnly ^ this.withdrawOnly);
        if (this.installOnly || both) {
            this.add = true;
            this.submitIntents(operations);
        }
        if (this.withdrawOnly || both) {
            this.add = false;
            this.submitIntents(operations);
        }
        this.service.removeListener((EventListener)this);
    }

    private List<Intent> generateIntents(ConnectPoint ingress, ConnectPoint egress) {
        TrafficSelector.Builder selectorBldr = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4);
        TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
        ArrayList intents = Lists.newArrayList();
        for (long i = 0L; i < (long)this.count; ++i) {
            TrafficSelector selector = selectorBldr.matchEthSrc(MacAddress.valueOf((long)(i + (long)this.keyOffset))).build();
            intents.add(PointToPointIntent.builder().appId(this.appId()).key(Key.of((long)(i + (long)this.keyOffset), (ApplicationId)this.appId())).selector(selector).treatment(treatment).filteredIngressPoint(new FilteredConnectPoint(ingress)).filteredEgressPoint(new FilteredConnectPoint(egress)).build());
            this.keysForInstall.add(Key.of((long)(i + (long)this.keyOffset), (ApplicationId)this.appId()));
            this.keysForWithdraw.add(Key.of((long)(i + (long)this.keyOffset), (ApplicationId)this.appId()));
        }
        return intents;
    }

    private void submitIntents(List<Intent> intents) {
        this.latch = new CountDownLatch(this.count);
        log.info("CountDownLatch is set with count of {}", (Object)this.count);
        this.start = System.currentTimeMillis();
        for (Intent intent : intents) {
            if (this.add) {
                this.service.submit(intent);
                continue;
            }
            this.service.withdraw(intent);
        }
        try {
            if (this.latch.await(1000L + (long)this.count * 60L, TimeUnit.MILLISECONDS)) {
                this.printResults(this.count);
            } else {
                this.print("Failure: %d intents not installed", this.latch.getCount());
            }
        }
        catch (InterruptedException e) {
            this.print(e.toString(), new Object[0]);
        }
    }

    private void printResults(int count) {
        long delta = this.end - this.start;
        String text = this.add ? "install" : "withdraw";
        this.print("Time to %s %d intents: %d ms", text, count, delta);
    }

    private String getPortNumber(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(slash + 1, deviceString.length());
    }

    private String getDeviceId(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(0, slash);
    }

    public synchronized void event(IntentEvent event) {
        if (!this.appId().equals(((Intent)event.subject()).appId())) {
            return;
        }
        IntentEvent.Type expected = this.add ? IntentEvent.Type.INSTALLED : IntentEvent.Type.WITHDRAWN;
        List<Key> keylist = this.add ? this.keysForInstall : this.keysForWithdraw;
        log.debug("Event generated: {}", (Object)event);
        if (event.type() == expected && keylist.contains(((Intent)event.subject()).key())) {
            this.end = Math.max(this.end, event.time());
            keylist.remove(((Intent)event.subject()).key());
            if (this.latch != null) {
                if (this.latch.getCount() == 0L) {
                    log.warn("Latch was already 0 before counting down?");
                }
                this.latch.countDown();
                log.debug("Latch count is {}", (Object)this.latch.getCount());
            } else {
                log.warn("install event latch is null");
            }
        } else if (IGNORE_EVENT.contains(event.type())) {
            log.debug("Unexpected intent event: {}", (Object)event);
        }
    }
}

