/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net.completer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onosproject.cli.AbstractChoicesCompleter;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.link.LinkService;

@Service
public class PeerConnectPointCompleter
extends AbstractChoicesCompleter {
    @Override
    protected List<String> choices() {
        DeviceService deviceService = (DeviceService)DefaultServiceDirectory.getService(DeviceService.class);
        LinkService linkService = (LinkService)DefaultServiceDirectory.getService(LinkService.class);
        Optional<ConnectPoint> port = Arrays.asList(this.commandLine.getArguments()).stream().filter(s -> s.contains(":") && s.contains("/")).map(s -> {
            try {
                return ConnectPoint.deviceConnectPoint((String)s);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }).filter(Objects::nonNull).filter(cp -> deviceService.getPort(cp) != null).findFirst();
        if (!port.isPresent()) {
            return Collections.emptyList();
        }
        ConnectPoint cp2 = port.get();
        return linkService.getLinks(cp2).stream().flatMap(l -> Stream.of(l.src(), l.dst())).filter(peer -> !cp2.equals(peer)).distinct().map(ConnectPoint::toString).collect(Collectors.toList());
    }
}

