/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.DriverNameCompleter;
import org.onosproject.net.driver.Behaviour;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverService;

@Service
@Command(scope="onos", name="drivers", description="Lists device drivers")
public class DriversListCommand
extends AbstractShellCommand {
    private static final String FMT = "driver=%s, extends=%s, mfr=%s, hw=%s, sw=%s";
    private static final String FMT_B = "   %s via %s";
    private static final String FMT_P = "   %s=%s";
    @Argument(index=0, name="driverName", description="Driver name", required=false, multiValued=false)
    @Completion(value=DriverNameCompleter.class)
    String driverName = null;
    @Option(name="-s", aliases={"--sort"}, description="Sort output by driver name", required=false, multiValued=false)
    private boolean sort = false;
    @Option(name="-n", aliases={"--name"}, description="Show driver name only", required=false, multiValued=false)
    private boolean nameOnly = false;

    @Override
    protected void doExecute() {
        DriverService service = DriversListCommand.get(DriverService.class);
        if (this.driverName != null) {
            this.printDriver(service.getDriver(this.driverName), true);
        } else if (this.outputJson()) {
            this.json(service.getDrivers());
        } else {
            service.getDrivers().stream().sorted(Comparator.comparing(Driver::name)).forEach(d -> this.printDriver((Driver)d, true));
        }
    }

    private void json(Driver driver) {
        this.print("%s", this.jsonForEntity(driver, Driver.class));
    }

    private void json(Set<Driver> drivers) {
        ArrayNode result = this.mapper().createArrayNode();
        drivers.forEach(driver -> result.add((JsonNode)this.jsonForEntity(driver, Driver.class)));
        this.print("%s", result.toString());
    }

    private void printDriver(Driver driver, boolean first) {
        if (this.outputJson()) {
            this.json(driver);
        } else if (this.nameOnly) {
            this.print("%s", driver.name());
        } else {
            List parents = Optional.ofNullable(driver.parents()).orElse((List)ImmutableList.of());
            List parentsNames = parents.stream().map(Driver::name).collect(Collectors.toList());
            if (first) {
                this.print(FMT, driver.name(), parentsNames, driver.manufacturer(), driver.hwVersion(), driver.swVersion());
            } else {
                this.print("   Inherited from %s", driver.name());
            }
            driver.behaviours().forEach(b -> this.printBehaviour((Class<? extends Behaviour>)b, driver));
            driver.properties().forEach((k, v) -> this.print(FMT_P, k, v));
            parents.stream().forEach(parent -> this.printDriver((Driver)parent, false));
        }
    }

    private void printBehaviour(Class<? extends Behaviour> behaviour, Driver driver) {
        this.print(FMT_B, behaviour.getCanonicalName(), driver.implementation(behaviour).getCanonicalName());
    }
}

