/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.Optional;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.DeviceIdCompleter;
import org.onosproject.cli.net.PortNumberCompleter;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.DeviceId;
import org.onosproject.net.GridType;
import org.onosproject.net.OchSignal;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.Resources;

@Service
@Command(scope="onos", name="test-allocate-resources", description="Test tool to allocate resources")
public class TestAllocateResource
extends AbstractShellCommand {
    @Option(name="-l", aliases={"--lambda"}, description="Lambda Resource to allocate", required=false, multiValued=false)
    private String lambda = "1";
    @Option(name="-i", aliases={"--intentId"}, description="IntentId to use for allocation", required=false, multiValued=false)
    private int nIntendId = 42;
    @Argument(index=0, name="deviceId", description="Device ID", required=true, multiValued=false)
    @Completion(value=DeviceIdCompleter.class)
    String deviceIdStr = null;
    @Argument(index=1, name="portNumber", description="PortNumber", required=true, multiValued=false)
    @Completion(value=PortNumberCompleter.class)
    String portNumberStr = null;
    private ResourceService resourceService;

    @Override
    protected void doExecute() {
        this.resourceService = TestAllocateResource.get(ResourceService.class);
        DeviceId did = DeviceId.deviceId((String)this.deviceIdStr);
        PortNumber portNum = PortNumber.fromString((String)this.portNumberStr);
        IntentId consumer = IntentId.valueOf((long)this.nIntendId);
        DiscreteResource resource = Resources.discrete((DeviceId)did, (PortNumber)portNum, (Object[])new Object[]{this.createLambda(Integer.parseInt(this.lambda))}).resource();
        Optional allocate = this.resourceService.allocate((ResourceConsumer)consumer, (Resource)resource);
        if (allocate.isPresent()) {
            this.print("Allocated: %s", allocate.get());
        } else {
            this.print("Failed to allocate %s for %s", resource, consumer);
        }
    }

    private OchSignal createLambda(int i) {
        return new OchSignal(GridType.FLEX, ChannelSpacing.CHL_6P25GHZ, i, 1);
    }
}

