/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.pi.model.PiPipeconf;
import org.onosproject.net.pi.service.PiPipeconfService;

@Service
@Command(scope="onos", name="pipeconfs", description="List registered pipeconfs")
public class PipeconfCommand
extends AbstractShellCommand {
    protected PiPipeconfService piPipeconfService;
    @Option(name="-s", aliases={"--short"}, description="Print more succinct output for each pipeconf", required=false, multiValued=false)
    private boolean shortOutput = false;

    @Override
    protected void doExecute() {
        this.piPipeconfService = PipeconfCommand.get(PiPipeconfService.class);
        for (PiPipeconf piPipeconf : this.piPipeconfService.getPipeconfs()) {
            if (this.shortOutput) {
                this.print("id=%s", piPipeconf.id().toString());
                continue;
            }
            this.print("id=%s, behaviors=%s, extensions=%s", piPipeconf.id().toString(), this.getBehaviors(piPipeconf), this.getExtensions(piPipeconf));
        }
    }

    private String getBehaviors(PiPipeconf piPipeconf) {
        Collection behaviours = piPipeconf.behaviours();
        ArrayList<String> result = new ArrayList<String>();
        for (Class behaviour : behaviours) {
            result.add(behaviour.getSimpleName());
        }
        return result.toString();
    }

    private String getExtensions(PiPipeconf piPipeconf) {
        ArrayList<String> result = new ArrayList<String>();
        for (PiPipeconf.ExtensionType extensionType : PiPipeconf.ExtensionType.values()) {
            if (!piPipeconf.extension(extensionType).isPresent()) continue;
            result.add(extensionType.name());
        }
        return result.toString();
    }
}

