/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.DeviceIdCompleter;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.edge.EdgePortService;
import org.onosproject.utils.Comparators;

@Service
@Command(scope="onos", name="edge-ports", description="Lists all edge ports.")
public class EdgePortsListCommand
extends AbstractShellCommand {
    private static final String FMT = "%s/%s";
    @Argument(index=0, name="uri", description="Device ID", required=false, multiValued=false)
    @Completion(value=DeviceIdCompleter.class)
    String uri = null;

    @Override
    protected void doExecute() {
        EdgePortService service = EdgePortsListCommand.get(EdgePortService.class);
        if (this.uri == null) {
            this.printEdgePoints(service.getEdgePoints());
        } else {
            this.printEdgePoints(service.getEdgePoints(DeviceId.deviceId((String)this.uri)));
        }
    }

    private void printEdgePoints(Iterable<ConnectPoint> edgePoints) {
        List<ConnectPoint> sorted = EdgePortsListCommand.sort(edgePoints);
        if (this.outputJson()) {
            ArrayNode result = this.mapper().createObjectNode().putArray(null);
            sorted.forEach(e -> result.add((JsonNode)this.mapper().createObjectNode().put(e.deviceId().toString(), e.port().toString())));
            this.print("%s", result.toString());
        } else {
            sorted.forEach(e -> this.print(FMT, e.deviceId(), e.port()));
        }
    }

    private static List<ConnectPoint> sort(Iterable<ConnectPoint> connectPoints) {
        ArrayList edgePoints = Lists.newArrayList(connectPoints);
        Collections.sort(edgePoints, Comparators.CONNECT_POINT_COMPARATOR);
        return edgePoints;
    }
}

