/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.cfg;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigRegistry;

@Service
@Command(scope="onos", name="netcfg-registry", description="Displays network configuration registry contents")
public class NetworkConfigRegistryCommand
extends AbstractShellCommand {
    private static final String FMT = "subjectKey=%s, configKey=%s, subjectClass=%s, configClass=%s";
    private static final String SHORT_FMT = "%-12s %-12s %-40s %s";
    @Option(name="-s", aliases={"--short"}, description="Show short output only", required=false, multiValued=false)
    private boolean shortOnly = false;

    @Override
    protected void doExecute() {
        NetworkConfigRegistryCommand.get(NetworkConfigRegistry.class).getConfigFactories().forEach(this::print);
    }

    private void print(ConfigFactory configFactory) {
        this.print(this.shortOnly ? SHORT_FMT : FMT, configFactory.subjectFactory().subjectClassKey(), configFactory.configKey(), configFactory.subjectFactory().subjectClass().getName(), configFactory.configClass().getName());
    }
}

