/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.ConnectPointCompleter;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.statistic.Load;
import org.onosproject.net.statistic.StatisticService;

@Service
@Command(scope="onos", name="get-stats", description="Fetches stats for a connection point")
public class GetStatisticsCommand
extends AbstractShellCommand {
    @Argument(index=0, name="connectPoint", description="Device/Port Description", required=true, multiValued=false)
    @Completion(value=ConnectPointCompleter.class)
    String connectPoint = null;

    @Override
    protected void doExecute() {
        StatisticService service = GetStatisticsCommand.get(StatisticService.class);
        DeviceId ingressDeviceId = DeviceId.deviceId((String)this.getDeviceId(this.connectPoint));
        PortNumber ingressPortNumber = PortNumber.portNumber((String)this.getPortNumber(this.connectPoint));
        ConnectPoint cp = new ConnectPoint((ElementId)ingressDeviceId, ingressPortNumber);
        Load load = service.load(cp);
        this.print("Load on %s -> %s", cp, load);
    }

    private String getPortNumber(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(slash + 1, deviceString.length());
    }

    private String getDeviceId(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(0, slash);
    }
}

