/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.security;

import java.security.Permission;
import java.util.List;
import java.util.Map;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.app.ApplicationAdminService;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.security.ReviewApplicationNameCompleter;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.security.SecurityAdminService;
import org.onosproject.security.SecurityUtil;

@Service
@Command(scope="onos", name="review", description="Application security policy review interface")
public class ReviewCommand
extends AbstractShellCommand {
    @Argument(index=0, name="name", description="Application name", required=true, multiValued=false)
    @Completion(value=ReviewApplicationNameCompleter.class)
    String name = null;
    @Argument(index=1, name="accept", description="Option to accept policy", required=false, multiValued=false)
    String accept = null;

    @Override
    protected void doExecute() {
        ApplicationAdminService applicationAdminService = ReviewCommand.get(ApplicationAdminService.class);
        ApplicationId appId = applicationAdminService.getId(this.name);
        if (appId == null) {
            this.print("No such application: %s", this.name);
            return;
        }
        Application app = applicationAdminService.getApplication(appId);
        SecurityAdminService smService = SecurityUtil.getSecurityService();
        if (smService == null) {
            this.print("Security Mode is disabled", new Object[0]);
            return;
        }
        if (this.accept == null) {
            smService.review(appId);
            this.printPolicy(smService, app);
        } else if ("accept".equals(this.accept.trim())) {
            smService.acceptPolicy(appId);
            this.printPolicy(smService, app);
        } else {
            this.print("Unknown command", new Object[0]);
        }
    }

    private void printPolicy(SecurityAdminService smService, Application app) {
        this.print("\n*******************************", new Object[0]);
        this.print("       SM-ONOS APP REVIEW      ", new Object[0]);
        this.print("*******************************", new Object[0]);
        this.print("Application name: %s ", app.id().name());
        this.print("Application role: " + app.role(), new Object[0]);
        this.print("\nDeveloper specified permissions: ", new Object[0]);
        this.printMap(smService.getPrintableSpecifiedPermissions(app.id()));
        this.print("\nPermissions granted: ", new Object[0]);
        this.printMap(smService.getPrintableGrantedPermissions(app.id()));
        this.print("\nAdditional permissions requested on runtime (POLICY VIOLATIONS): ", new Object[0]);
        this.printMap(smService.getPrintableRequestedPermissions(app.id()));
        this.print("", new Object[0]);
    }

    private void printMap(Map<Integer, List<Permission>> assortedMap) {
        block7: for (Integer type : assortedMap.keySet()) {
            switch (type) {
                case 0: {
                    for (Permission perm : assortedMap.get(0)) {
                        this.print("\t[APP PERMISSION] " + perm.getName(), new Object[0]);
                    }
                    continue block7;
                }
                case 1: {
                    for (Permission perm : assortedMap.get(1)) {
                        this.print("\t[NB-ADMIN SERVICE] " + perm.getName() + "(" + perm.getActions() + ")", new Object[0]);
                    }
                    continue block7;
                }
                case 2: {
                    for (Permission perm : assortedMap.get(2)) {
                        this.print("\t[NB SERVICE] " + perm.getName() + "(" + perm.getActions() + ")", new Object[0]);
                    }
                    continue block7;
                }
                case 3: {
                    for (Permission perm : assortedMap.get(3)) {
                        this.print("\t[Other SERVICE] " + perm.getName() + "(" + perm.getActions() + ")", new Object[0]);
                    }
                    continue block7;
                }
                case 4: {
                    for (Permission perm : assortedMap.get(4)) {
                        this.print("\t[Other] " + perm.getClass().getSimpleName() + " " + perm.getName() + " (" + perm.getActions() + ")", new Object[0]);
                    }
                    continue block7;
                }
            }
        }
    }
}

