/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.net.DeviceIdCompleter;
import org.onosproject.cli.net.DevicesListCommand;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.device.DeviceService;
import org.onosproject.utils.Comparators;

@Service
@Command(scope="onos", name="ports", description="Lists all ports or all ports of a device")
public class DevicePortsListCommand
extends DevicesListCommand {
    private static final String FMT = "  port=%s, state=%s, type=%s, speed=%s %s";
    @Option(name="-e", aliases={"--enabled"}, description="Show only enabled ports", required=false, multiValued=false)
    @Completion(value=DeviceIdCompleter.class)
    private boolean enabled = false;
    @Option(name="-d", aliases={"--disabled"}, description="Show only disabled ports", required=false, multiValued=false)
    private boolean disabled = false;
    @Argument(index=0, name="uri", description="Device ID", required=false, multiValued=false)
    @Completion(value=DeviceIdCompleter.class)
    protected String uri = null;

    @Override
    protected void doExecute() {
        DeviceService service = DevicePortsListCommand.get(DeviceService.class);
        if (this.uri == null) {
            if (this.outputJson()) {
                this.print("%s", this.jsonPorts(service, DevicePortsListCommand.getSortedDevices(service)));
            } else {
                for (Device device : DevicePortsListCommand.getSortedDevices(service)) {
                    this.printDevice(service, device);
                    this.printPorts(service, device);
                }
            }
        } else {
            Device device = service.getDevice(DeviceId.deviceId((String)this.uri));
            if (device == null) {
                this.error("No such device %s", this.uri);
            } else if (this.outputJson()) {
                this.print("%s", this.jsonPorts(service, new ObjectMapper(), device));
            } else {
                this.printDevice(service, device);
                this.printPorts(service, device);
            }
        }
    }

    public JsonNode jsonPorts(DeviceService service, Iterable<Device> devices) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (Device device : devices) {
            result.add(this.jsonPorts(service, mapper, device));
        }
        return result;
    }

    public JsonNode jsonPorts(DeviceService service, ObjectMapper mapper, Device device) {
        ObjectNode result = mapper.createObjectNode();
        ArrayNode ports = mapper.createArrayNode();
        for (Port port : service.getPorts(device.id())) {
            if (!this.isIncluded(port)) continue;
            ports.add(mapper.createObjectNode().put("element", device.id().toString()).put("port", port.number().toString()).put("isEnabled", port.isEnabled()).put("type", port.type().toString().toLowerCase()).put("portSpeed", port.portSpeed()).set("annotations", (JsonNode)DevicePortsListCommand.annotations(mapper, port.annotations())));
        }
        result.set("device", (JsonNode)this.jsonForEntity(device, Device.class));
        result.set("ports", (JsonNode)ports);
        return result;
    }

    protected boolean isIncluded(Port port) {
        return this.enabled && port.isEnabled() || this.disabled && !port.isEnabled() || !this.enabled && !this.disabled;
    }

    protected void printPorts(DeviceService service, Device device) {
        ArrayList ports = new ArrayList(service.getPorts(device.id()));
        Collections.sort(ports, Comparators.PORT_COMPARATOR);
        for (Port port : ports) {
            if (!this.isIncluded(port)) continue;
            String portName = port.number().toString();
            String portIsEnabled = port.isEnabled() ? "enabled" : "disabled";
            String portType = port.type().toString().toLowerCase();
            String annotations = DevicePortsListCommand.annotations(port.annotations());
            this.print(FMT, portName, portIsEnabled, portType, port.portSpeed(), annotations);
        }
    }
}

