/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.intf.Interface;
import org.onosproject.net.neighbour.NeighbourResolutionService;

@Service
@Command(scope="onos", name="neighbour-handlers", description="Lists neighbour message handlers")
public class NeighbourHandlersListCommand
extends AbstractShellCommand {
    private static final String FORMAT = "%20s: interface=%s, class=%s";

    @Override
    protected void doExecute() {
        NeighbourResolutionService service = NeighbourHandlersListCommand.get(NeighbourResolutionService.class);
        service.getHandlerRegistrations().forEach((cp, list) -> list.forEach(hr -> this.print(FORMAT, cp, this.intfToName(hr.intf()), hr.handler().getClass().getCanonicalName())));
    }

    private String intfToName(Interface intf) {
        return intf == null ? "(None)" : intf.name();
    }
}

