/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.StorageService;

@Service
@Command(scope="onos", name="counter", description="Displays the current value of a atomic counter")
public class CounterCommand
extends AbstractShellCommand {
    @Argument(index=0, name="counterName", description="Counter Name", required=true, multiValued=false)
    String name = null;

    @Override
    protected void doExecute() {
        StorageService storageService = CounterCommand.get(StorageService.class);
        AtomicCounter counter = storageService.getAtomicCounter(this.name);
        if (this.outputJson()) {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode counterJsonNode = mapper.createObjectNode();
            counterJsonNode.put("value", counter.get());
            this.print("%s", counterJsonNode);
        } else {
            this.print("%d", counter.get());
        }
    }
}

