/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.ListMultimap;
import java.util.Map;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onlab.osgi.ServiceNotFoundException;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.flowobjective.FlowObjectiveService;

@Service
@Command(scope="onos", name="obj-queues", description="Display flow objective queues")
public class FlowObjectiveQueueListCommand
extends AbstractShellCommand {
    @Option(name="-s", aliases={"--size"}, description="Print queue size only", required=false, multiValued=false)
    private boolean sizeOnly = false;
    @Option(name="-c", aliases={"--cache"}, description="Print cache", required=false, multiValued=false)
    private boolean cache = false;

    @Override
    protected void doExecute() {
        try {
            FlowObjectiveService service = FlowObjectiveQueueListCommand.get(FlowObjectiveService.class);
            ListMultimap filtObjQueue = service.getFilteringObjQueue();
            ListMultimap fwdObjQueue = service.getForwardingObjQueue();
            ListMultimap nextObjQueue = service.getNextObjQueue();
            Map filtObjQueueHead = service.getFilteringObjQueueHead();
            Map fwdObjQueueHead = service.getForwardingObjQueueHead();
            Map nextObjQueueHead = service.getNextObjQueueHead();
            if (this.cache) {
                this.printMap("Filtering objective cache", filtObjQueueHead, this.sizeOnly);
                this.printMap("Forwarding objective cache", fwdObjQueueHead, this.sizeOnly);
                this.printMap("Next objective cache", nextObjQueueHead, this.sizeOnly);
            } else {
                this.printMap("Filtering objective queue", filtObjQueue.asMap(), this.sizeOnly);
                this.printMap("Forwarding objective queue", fwdObjQueue.asMap(), this.sizeOnly);
                this.printMap("Next objective queue", nextObjQueue.asMap(), this.sizeOnly);
            }
        }
        catch (ServiceNotFoundException e) {
            this.print("FlowObjectiveService unavailable", new Object[0]);
        }
    }

    private void printMap(String mapName, Map map, boolean sizeOnly) {
        this.print("%s size = %d", mapName, map.size());
        if (!sizeOnly) {
            map.forEach((k, v) -> this.print("%s -> %s", k, v));
        }
    }
}

