/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onlab.util.Tools;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.completer.IntentIdCompleter;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.intent.IntentService;

@Service
@Command(scope="onos", name="intent-details", description="Displays intent details")
public class IntentDetailsCommand
extends AbstractShellCommand {
    @Option(name="--id", description="Filter intent by specific Id", multiValued=true)
    @Completion(value=IntentIdCompleter.class)
    private List<String> idsStr;
    private Set<IntentId> ids = null;

    @Override
    protected void doExecute() {
        this.detailIntents(this.idsStr);
    }

    public void detailIntents(List<String> intentsIds) {
        if (intentsIds != null) {
            this.ids = intentsIds.stream().map(IntentId::valueOf).collect(Collectors.toSet());
        }
        IntentService service = IntentDetailsCommand.get(IntentService.class);
        Tools.stream((Iterable)service.getIntentData()).filter(this::filter).forEach(this::printIntentData);
    }

    private boolean filter(IntentData data) {
        return this.ids == null || this.ids.contains(data.intent().id());
    }

    private void printIntentData(IntentData data) {
        this.print("Key: %s ID: %s", data.key(), data.intent().id());
        this.print(" Request: %s Current: %s", data.request(), data.state());
        this.print(" intent: %s", this.s(data.intent()));
        data.installables().stream().forEach(this::printInstallable);
        this.print("", new Object[0]);
    }

    private void printInstallable(Intent installable) {
        this.print(" installable: %s %s", installable.getClass().getSimpleName(), installable.id());
        this.print("  resources: %s", installable.resources().stream().filter((? super T r) -> !(r instanceof Link)).map(this::s).collect(Collectors.joining(", ")));
        Object[] objectArray = new Object[1];
        objectArray[0] = installable.resources().stream().filter(Link.class::isInstance).map(Link.class::cast).map(LinkKey::linkKey).map(l -> String.format("%s -> %s", l.src(), l.dst())).collect(Collectors.joining(", "));
        this.print("  links: %s", objectArray);
    }

    protected String s(Object o) {
        return IntentDetailsCommand.simplify(String.valueOf(o));
    }

    public static String simplify(String input) {
        String after = input.replaceAll("treatment=DefaultTrafficTreatment", "treatment=").replaceAll("selector=DefaultTrafficSelector", "selector=").replaceAll("DefaultApplicationId\\{id=(\\d+), name=([.\\w]+)\\}", "$2($1)").replaceAll("(, )?\\w+=\\[\\]", "").replaceAll("(, )?\\w+=\\{\\}", "").replaceAll("(, )?\\w+\\{\\}", "\\{\\}").replaceAll("FilteredConnectPoint", "").replaceAll("Default(\\w+)\\{", "$1\\{").replaceAll(", , ", ", ");
        return after.equals(input) ? input : IntentDetailsCommand.simplify(after);
    }
}

