/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.OptionalInt;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentExtensionService;

@Service
@Command(scope="onos", name="intent-compilers", description="Lists the mapping from intent type to compiler component")
public class IntentListCompilers
extends AbstractShellCommand {
    @Override
    protected void doExecute() {
        IntentExtensionService service = IntentListCompilers.get(IntentExtensionService.class);
        OptionalInt length = service.getCompilers().keySet().stream().mapToInt(s -> s.getName().length()).max();
        if (length.isPresent()) {
            service.getCompilers().entrySet().forEach(e -> this.print("%-" + length.getAsInt() + "s\t%s", ((Class)e.getKey()).getName(), ((IntentCompiler)e.getValue()).getClass().getName()));
        } else {
            this.print("There are no compilers registered.", new Object[0]);
        }
    }
}

