/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;
import org.onosproject.net.region.RegionService;
import org.onosproject.ui.UiTopoLayoutService;
import org.onosproject.ui.model.topo.UiTopoLayout;
import org.onosproject.ui.model.topo.UiTopoLayoutId;

@Service
@Command(scope="onos", name="layout-add", description="Adds a new UI layout.")
public class LayoutAddCommand
extends AbstractShellCommand {
    private static final char CODE_GEO = '@';
    private static final char CODE_GRID = '+';
    private static final String NULL_TOKEN = ".";
    private static final String ROOT = "root";
    private static final double DEFAULT_SCALE = 1.0;
    private static final double DEFAULT_OFFSET = 0.0;
    @Argument(index=0, name="id", description="Layout ID", required=true, multiValued=false)
    String id = null;
    @Argument(index=1, name="bgref", description="Background Ref", required=true, multiValued=false)
    String backgroundRef = null;
    @Argument(index=2, name="rid", description="Region ID (optional)", required=false, multiValued=false)
    String regionId = null;
    @Argument(index=3, name="plid", description="Parent layout ID (optional)", required=false, multiValued=false)
    String parentId = null;
    @Argument(index=4, name="scale", description="Zoom scale (optional; default 1.0)", required=false, multiValued=false)
    String zoomScale = null;
    @Argument(index=5, name="offx", description="Zoom offset-X (optional; default 0.0)", required=false, multiValued=false)
    String zoomOffsetX = null;
    @Argument(index=6, name="offy", description="Zoom offset-Y (optional; default 0.0)", required=false, multiValued=false)
    String zoomOffsetY = null;
    private RegionService regionService;

    @Override
    protected void doExecute() {
        UiTopoLayoutService service = LayoutAddCommand.get(UiTopoLayoutService.class);
        RegionService regionService = LayoutAddCommand.get(RegionService.class);
        if (ROOT.equals(this.id)) {
            UiTopoLayout layout = service.getRootLayout();
            this.setAppropriateBackground(layout);
            this.setZoomParameters(layout);
            return;
        }
        Region region = this.nullToken(this.regionId) ? null : regionService.getRegion(RegionId.regionId((String)this.regionId));
        UiTopoLayoutId pid = this.nullToken(this.parentId) ? UiTopoLayoutId.DEFAULT_ID : UiTopoLayoutId.layoutId((String)this.parentId);
        UiTopoLayout layout = new UiTopoLayout(UiTopoLayoutId.layoutId((String)this.id)).region(region).parent(pid);
        this.setAppropriateBackground(layout);
        this.setZoomParameters(layout);
        service.addLayout(layout);
    }

    private boolean nullToken(String token) {
        return token == null || token.equals(NULL_TOKEN);
    }

    private void setAppropriateBackground(UiTopoLayout layout) {
        char type = this.backgroundRef.charAt(0);
        if (type == '@') {
            layout.geomap(this.backgroundRef.substring(1));
        } else if (type == '+') {
            layout.sprites(this.backgroundRef.substring(1));
        }
    }

    private double parseDouble(String s, double def) {
        double result;
        if (this.nullToken(s)) {
            return def;
        }
        try {
            result = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            result = def;
        }
        return result;
    }

    private void setZoomParameters(UiTopoLayout layout) {
        double scale = this.parseDouble(this.zoomScale, 1.0);
        double offsetX = this.parseDouble(this.zoomOffsetX, 0.0);
        double offsetY = this.parseDouble(this.zoomOffsetY, 0.0);
        layout.scale(scale).offsetX(offsetX).offsetY(offsetY);
    }
}

