/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.app;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.app.ApplicationAdminService;
import org.onosproject.app.ApplicationService;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.app.ApplicationCommandCompleter;
import org.onosproject.cli.app.ApplicationNameCompleter;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.VersionService;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Service
@Command(scope="onos", name="app", description="Manages application inventory")
public class ApplicationCommand
extends AbstractShellCommand {
    static final String INSTALL = "install";
    static final String UNINSTALL = "uninstall";
    static final String ACTIVATE = "activate";
    static final String DEACTIVATE = "deactivate";
    static final String DOWNLOAD = "download";
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected VersionService versionService;
    @Argument(index=0, name="command", description="Command name (install|activate|deactivate|uninstall|download|installreg)", required=true)
    @Completion(value=ApplicationCommandCompleter.class)
    String command = null;
    @Argument(index=1, name="names", description="Application name(s) or URL(s)", required=true, multiValued=true)
    @Completion(value=ApplicationNameCompleter.class)
    String[] names = null;

    @Override
    protected void doExecute() {
        ApplicationAdminService service = ApplicationCommand.get(ApplicationAdminService.class);
        if (this.command.equals(INSTALL)) {
            for (String name : this.names) {
                if (this.installApp(service, name)) continue;
                return;
            }
        } else if (this.command.equals(DOWNLOAD)) {
            for (String name : this.names) {
                if (this.downloadApp(service, name)) continue;
                return;
            }
        } else {
            for (String name : this.names) {
                if (this.manageApp(service, name)) continue;
                return;
            }
        }
    }

    private boolean installApp(ApplicationAdminService service, String url) {
        try {
            if ("-".equals(url)) {
                service.install(System.in);
            } else if (url.contains("oar")) {
                service.install(new URL(url).openStream());
            } else {
                Set app = ApplicationCommand.get(ApplicationService.class).getRegisteredApplications();
                if (app.isEmpty()) {
                    System.out.println("Could Not Install " + url);
                    return false;
                }
                Iterator iterator = app.iterator();
                Application recent = null;
                while (iterator.hasNext()) {
                    Application application = (Application)iterator.next();
                    if (recent == null && application.id().name().equals(url)) {
                        recent = application;
                        continue;
                    }
                    if (application.version().compareTo(recent.version()) <= 0 || !application.id().name().equals(url)) continue;
                    recent = application;
                }
                service.install(recent.imageUrl().openStream());
            }
        }
        catch (IOException e) {
            this.error("Unable to get URL: %s", url);
            return false;
        }
        return true;
    }

    private boolean downloadApp(ApplicationAdminService service, String name) {
        try {
            ByteStreams.copy((InputStream)service.getApplicationArchive(service.getId(name)), (OutputStream)System.out);
        }
        catch (IOException e) {
            this.error("Unable to download bits for application %s", name);
            return false;
        }
        return true;
    }

    private boolean manageApp(ApplicationAdminService service, String name) {
        String action;
        ApplicationId appId = service.getId(name);
        if (appId == null) {
            List matches = service.getApplications().stream().filter(app -> app.id().name().matches(".*\\." + name + "$")).collect(Collectors.toList());
            if (matches.size() == 1) {
                appId = ((Application)matches.iterator().next()).id();
            } else if (!matches.isEmpty()) {
                this.print("Did you mean one of: %s", matches.stream().map(Application::id).map(ApplicationId::name).collect(Collectors.toList()));
                return false;
            }
        }
        if (appId == null) {
            this.print("No such application: %s", name);
            return false;
        }
        if (this.command.equals(UNINSTALL)) {
            service.uninstall(appId);
            action = "Uninstalled";
        } else if (this.command.equals(ACTIVATE)) {
            service.activate(appId);
            action = "Activated";
        } else if (this.command.equals(DEACTIVATE)) {
            service.deactivate(appId);
            action = "Deactivated";
        } else {
            this.print("Unsupported command: %s", this.command);
            return false;
        }
        this.print("%s %s", action, appId.name());
        return true;
    }
}

