/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.store.service.StorageAdminService;

@Service
@Command(scope="onos", name="queues", description="Lists information about work queues in the system")
public class QueuesListCommand
extends AbstractShellCommand {
    private static final String FMT = "name=%s pending=%d inProgress=%d, completed=%d";

    @Override
    protected void doExecute() {
        StorageAdminService storageAdminService = QueuesListCommand.get(StorageAdminService.class);
        Map queueStats = storageAdminService.getQueueStats();
        if (this.outputJson()) {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode jsonQueues = mapper.createObjectNode();
            queueStats.forEach((k, v) -> {
                ObjectNode jsonStats = jsonQueues.putObject(k);
                jsonStats.put("pending", v.totalPending());
                jsonStats.put("inProgress", v.totalInProgress());
                jsonStats.put("completed", v.totalCompleted());
            });
            this.print("%s", jsonQueues);
        } else {
            queueStats.forEach((name, stats) -> this.print(FMT, name, stats.totalPending(), stats.totalInProgress(), stats.totalCompleted()));
        }
    }
}

