/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.DeviceIdCompleter;
import org.onosproject.cli.net.RegionIdCompleter;
import org.onosproject.net.DeviceId;
import org.onosproject.net.region.RegionAdminService;
import org.onosproject.net.region.RegionId;

@Service
@Command(scope="onos", name="region-remove-devices", description="Removes a set of devices from the region.")
public class RegionRemoveDevicesCommand
extends AbstractShellCommand {
    @Argument(index=0, name="id", description="Region ID", required=true, multiValued=false)
    @Completion(value=RegionIdCompleter.class)
    String id = null;
    @Argument(index=1, name="devIds", description="Device IDs", required=true, multiValued=true)
    @Completion(value=DeviceIdCompleter.class)
    List<String> devIds = null;

    @Override
    protected void doExecute() {
        RegionAdminService service = RegionRemoveDevicesCommand.get(RegionAdminService.class);
        RegionId regionId = RegionId.regionId((String)this.id);
        List dids = this.devIds.stream().map(s -> DeviceId.deviceId((String)s)).collect(Collectors.toList());
        service.removeDevices(regionId, dids);
    }
}

