/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.DeviceIdCompleter;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.DriverService;

@Service
@Command(scope="onos", name="device-drivers", description="list all devices and their driver names or a driver name of a device")
public class DeviceDriversCommand
extends AbstractShellCommand {
    @Argument(index=0, name="uri", description="Device ID", required=false, multiValued=false)
    @Completion(value=DeviceIdCompleter.class)
    String uri = null;

    @Override
    protected void doExecute() {
        DriverService service = DeviceDriversCommand.get(DriverService.class);
        if (this.uri == null) {
            Map deviceDriverNameMap = service.getDeviceDrivers();
            if (this.outputJson()) {
                this.json(deviceDriverNameMap);
            } else {
                deviceDriverNameMap.forEach((k, v) -> this.print("%s : %s", k.toString(), v));
            }
        } else {
            DeviceId deviceId = DeviceId.deviceId((String)this.uri);
            String driverName = service.getDriver(deviceId).name();
            if (this.outputJson()) {
                this.json(deviceId, driverName);
            } else {
                this.print("%s : %s", deviceId.toString(), driverName);
            }
        }
    }

    private void json(Map<DeviceId, String> map) {
        ObjectNode result = this.mapper().createObjectNode();
        map.forEach((k, v) -> result.put(k.toString(), v));
        this.print("%s", result.toString());
    }

    private void json(DeviceId deviceId, String driverName) {
        ObjectNode result = this.mapper().createObjectNode();
        result.put(deviceId.toString(), driverName);
        this.print("%s", result.toString());
    }
}

