/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cluster.ClusterAdminService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.MembershipService;
import org.onosproject.utils.Comparators;

@Service
@Command(scope="onos", name="memberships", description="Lists information about memberships in the system")
public class MembershipsListCommand
extends AbstractShellCommand {
    @Override
    protected void doExecute() {
        MembershipService service = MembershipsListCommand.get(MembershipService.class);
        ClusterAdminService clusterService = MembershipsListCommand.get(ClusterAdminService.class);
        if (this.outputJson()) {
            this.print("%s", this.json(service));
        } else {
            service.getGroups().forEach(group -> {
                ArrayList members = Lists.newArrayList((Iterable)group.members());
                this.print("-------------------------------------------------------------------", new Object[0]);
                this.print("Version: %s, Members: %d", group.version(), members.size());
                members.sort(Comparators.MEMBERSHIP_COMPARATOR);
                members.forEach(member -> {
                    Optional<ControllerNode> controllerNode = Optional.ofNullable(clusterService.getNode(member.nodeId()));
                    if (!controllerNode.isPresent()) {
                        this.print(" id=%s, version=%s, self=%s", member.nodeId(), member.version(), member.equals((Object)service.getLocalMember()) ? "*" : "");
                    } else {
                        ControllerNode node = controllerNode.get();
                        this.print(" id=%s, ip=%s, tcpPort=%s, state=%s, self=%s", member.nodeId(), node.ip(), node.tcpPort(), clusterService.getState(node.id()), member.equals((Object)service.getLocalMember()) ? "*" : "");
                    }
                });
                this.print("-------------------------------------------------------------------", new Object[0]);
            });
        }
    }

    private JsonNode json(MembershipService service) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        service.getGroups().forEach(group -> {
            ObjectNode groupNode = mapper.createObjectNode();
            ArrayNode membersNode = mapper.createArrayNode();
            groupNode.put("version", group.version().toString());
            groupNode.put("members", (JsonNode)membersNode);
            group.members().forEach(member -> membersNode.add(member.nodeId().toString()));
            result.add((JsonNode)groupNode);
        });
        return result;
    }
}

