/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onlab.util.Bandwidth;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.DeviceIdCompleter;
import org.onosproject.cli.net.PortNumberCompleter;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.OchSignal;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.TributarySlot;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceConsumerId;
import org.onosproject.net.resource.ResourceId;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.Resources;

@Service
@Command(scope="onos", name="allocations", description="Lists allocated resources")
public class AllocationsCommand
extends AbstractShellCommand {
    @Option(name="-t", aliases={"--type"}, description="resource types to include in the list", required=false, multiValued=true)
    String[] typeStrings = null;
    Set<String> typesToPrint;
    @Option(name="-i", aliases={"--intentId"}, description="Intent ID to include in the list", required=false, multiValued=true)
    String[] intentStrings;
    Set<String> intentsToPrint;
    @Argument(index=0, name="deviceIdString", description="Device ID", required=false, multiValued=false)
    @Completion(value=DeviceIdCompleter.class)
    String deviceIdStr = null;
    @Argument(index=1, name="portNumberString", description="PortNumber", required=false, multiValued=false)
    @Completion(value=PortNumberCompleter.class)
    String portNumberStr = null;
    private DeviceService deviceService;
    private ResourceService resourceService;

    @Override
    protected void doExecute() {
        this.deviceService = AllocationsCommand.get(DeviceService.class);
        this.resourceService = AllocationsCommand.get(ResourceService.class);
        this.typesToPrint = this.typeStrings != null ? new HashSet<String>(Arrays.asList(this.typeStrings)) : Collections.emptySet();
        this.intentsToPrint = this.intentStrings != null ? new HashSet<String>(Arrays.asList(this.intentStrings)) : Collections.emptySet();
        if (this.deviceIdStr != null && this.portNumberStr != null) {
            DeviceId deviceId = DeviceId.deviceId((String)this.deviceIdStr);
            PortNumber portNumber = PortNumber.fromString((String)this.portNumberStr);
            this.printAllocation(deviceId, portNumber, 0);
        } else if (this.deviceIdStr != null) {
            DeviceId deviceId = DeviceId.deviceId((String)this.deviceIdStr);
            this.printAllocation(deviceId, 0);
        } else {
            this.printAllocation();
        }
    }

    private void printAllocation() {
        this.print("ROOT", new Object[0]);
        StreamSupport.stream(this.deviceService.getAvailableDevices().spliterator(), false).map(Device::id).forEach(did -> this.printAllocation((DeviceId)did, 1));
    }

    private void printAllocation(DeviceId did, int level) {
        this.print("%s%s", Strings.repeat((String)" ", (int)level), did);
        StreamSupport.stream(this.deviceService.getPorts(did).spliterator(), false).map(Port::number).forEach(num -> this.printAllocation(did, (PortNumber)num, level + 1));
    }

    private void printAllocation(DeviceId did, PortNumber num, int level) {
        DiscreteResourceId resourceId;
        List portConsumers;
        if (level == 0) {
            this.print("%s", did);
        }
        if ((portConsumers = this.resourceService.getResourceAllocations((ResourceId)(resourceId = Resources.discrete((DeviceId)did, (PortNumber)num, (Object[])new Object[0]).id())).stream().filter(this::isSubjectToPrint).map(ResourceAllocation::consumerId).map(AllocationsCommand::asVerboseString).collect(Collectors.toList())).isEmpty()) {
            this.print("%s%s", Strings.repeat((String)" ", (int)level), AllocationsCommand.asVerboseString(num));
        } else {
            this.print("%s%s allocated by %s", Strings.repeat((String)" ", (int)level), AllocationsCommand.asVerboseString(num), portConsumers);
        }
        ImmutableSet subResourceTypes = ImmutableSet.builder().add(OchSignal.class).add(VlanId.class).add(MplsLabel.class).add(Bandwidth.class).add(TributarySlot.class).build();
        for (Class t : subResourceTypes) {
            this.resourceService.getResourceAllocations(resourceId, t).stream().filter(a -> this.isSubjectToPrint((ResourceAllocation)a)).forEach(a -> this.print("%s%s allocated by %s", Strings.repeat((String)" ", (int)(level + 1)), a.resource().valueAs(Object.class).orElse(""), AllocationsCommand.asVerboseString(a.consumerId())));
        }
    }

    private boolean isSubjectToPrint(ResourceAllocation allocation) {
        if (!this.intentsToPrint.isEmpty() && allocation.consumerId().isClassOf(IntentId.class) && !this.intentsToPrint.contains(allocation.consumerId().toString())) {
            return false;
        }
        return this.typesToPrint.isEmpty() || this.typesToPrint.contains(allocation.resource().simpleTypeName());
    }

    private static String asVerboseString(Object obj) {
        String name = obj.getClass().getSimpleName();
        String toString = String.valueOf(obj);
        if (toString.startsWith(name)) {
            return toString;
        }
        return String.format("%s:%s", name, toString);
    }

    private static String asVerboseString(ResourceConsumerId consumerId) {
        return String.format("%s:%s", consumerId.consumerClass(), consumerId.value());
    }
}

