/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.Optional;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.OpticalConnectPointCompleter;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.Port;
import org.onosproject.net.behaviour.BitErrorRateState;
import org.onosproject.net.device.DeviceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Command(scope="onos", name="bit-error-rate", description="Get ber for specific optical-channel")
public class BitErrorCommand
extends AbstractShellCommand {
    private static final Logger log = LoggerFactory.getLogger(BitErrorCommand.class);
    @Argument(index=0, name="connection point", description="{DeviceID}/{PortNumber}", required=true, multiValued=false)
    @Completion(value=OpticalConnectPointCompleter.class)
    private String connectPoint = null;

    @Override
    protected void doExecute() throws Exception {
        Optional postFecBerVal;
        ConnectPoint cp;
        DeviceService deviceService = BitErrorCommand.get(DeviceService.class);
        Port port = deviceService.getPort(cp = ConnectPoint.deviceConnectPoint((String)this.connectPoint));
        if (port == null) {
            this.print("[ERROR] %s does not exist", cp);
            return;
        }
        Device device = deviceService.getDevice(cp.deviceId());
        BitErrorRateState bitErrorRateState = (BitErrorRateState)device.as(BitErrorRateState.class);
        Optional preFecBerVal = bitErrorRateState.getPreFecBer(cp.deviceId(), cp.port());
        if (preFecBerVal.isPresent()) {
            double preFecBer = preFecBerVal.orElse(Double.MIN_VALUE);
            this.print("The pre-fec-ber value in port %s on device %s is %f.", cp.port().toString(), cp.deviceId().toString(), preFecBer);
        }
        if ((postFecBerVal = bitErrorRateState.getPostFecBer(cp.deviceId(), cp.port())).isPresent()) {
            double postFecBer = postFecBerVal.orElse(Double.MIN_VALUE);
            this.print("The post-fec-ber value in port %s on device %s is %f.", cp.port().toString(), cp.deviceId().toString(), postFecBer);
        }
    }
}

