/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.DeviceIdCompleter;
import org.onosproject.cli.net.DevicesListCommand;
import org.onosproject.cli.net.PortNumberCompleter;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortStatistics;

@Service
@Command(scope="onos", name="portstats", description="Lists statistics of all ports in the system")
public class DevicePortStatsCommand
extends AbstractShellCommand {
    @Option(name="-nz", aliases={"--nonzero"}, description="Show only non-zero portstats", required=false, multiValued=false)
    private boolean nonzero = false;
    @Option(name="-d", aliases={"--delta"}, description="Show delta port statistics,only for the last polling interval", required=false, multiValued=false)
    private boolean delta = false;
    @Option(name="-t", aliases={"--table"}, description="Show delta port statistics in table format using human readable unit", required=false, multiValued=false)
    private boolean table = false;
    @Argument(index=0, name="uri", description="Device ID", required=false, multiValued=false)
    @Completion(value=DeviceIdCompleter.class)
    String uri = null;
    @Argument(index=1, name="portNumber", description="Port Number", required=false, multiValued=false)
    @Completion(value=PortNumberCompleter.class)
    String portNumberStr = null;
    PortNumber portNumber = null;
    private static final String FORMAT = "   port=%s, pktRx=%s, pktTx=%s, bytesRx=%s, bytesTx=%s, pktRxDrp=%s, pktTxDrp=%s, Dur=%s%s";

    @Override
    protected void doExecute() {
        DeviceService deviceService = DevicePortStatsCommand.get(DeviceService.class);
        if (this.portNumberStr != null) {
            this.portNumber = PortNumber.fromString((String)this.portNumberStr);
        }
        if (this.uri == null) {
            for (Device d : DevicesListCommand.getSortedDevices(deviceService)) {
                if (this.delta) {
                    if (this.table) {
                        this.printPortStatsDeltaTable(d.id(), deviceService.getPortDeltaStatistics(d.id()));
                        continue;
                    }
                    this.printPortStatsDelta(d.id(), deviceService.getPortDeltaStatistics(d.id()));
                    continue;
                }
                this.printPortStats(d.id(), deviceService.getPortStatistics(d.id()));
            }
        } else {
            Device d = deviceService.getDevice(DeviceId.deviceId((String)this.uri));
            if (d == null) {
                this.error("No such device %s", this.uri);
            } else if (this.delta) {
                if (this.table) {
                    this.printPortStatsDeltaTable(d.id(), deviceService.getPortDeltaStatistics(d.id()));
                } else {
                    this.printPortStatsDelta(d.id(), deviceService.getPortDeltaStatistics(d.id()));
                }
            } else {
                this.printPortStats(d.id(), deviceService.getPortStatistics(d.id()));
            }
        }
    }

    private void printPortStats(DeviceId deviceId, Iterable<PortStatistics> portStats) {
        this.print("deviceId=%s", deviceId);
        for (PortStatistics stat : DevicePortStatsCommand.sortByPort(portStats)) {
            if (this.isIrrelevant(stat) || this.nonzero && stat.isZero()) continue;
            this.print(FORMAT, stat.portNumber(), stat.packetsReceived(), stat.packetsSent(), stat.bytesReceived(), stat.bytesSent(), stat.packetsRxDropped(), stat.packetsTxDropped(), stat.durationSec(), DevicePortStatsCommand.annotations(stat.annotations()));
        }
    }

    private boolean isIrrelevant(PortStatistics stat) {
        return this.portNumber != null && !this.portNumber.equals((Object)stat.portNumber());
    }

    private void printPortStatsDelta(DeviceId deviceId, Iterable<PortStatistics> portStats) {
        String formatDelta = "   port=%s, pktRx=%s, pktTx=%s, bytesRx=%s, bytesTx=%s, rateRx=%s, rateTx=%s, pktRxDrp=%s, pktTxDrp=%s, interval=%s";
        this.print("deviceId=%s", deviceId);
        for (PortStatistics stat : DevicePortStatsCommand.sortByPort(portStats)) {
            if (this.isIrrelevant(stat) || this.nonzero && stat.isZero()) continue;
            float duration = (float)stat.durationSec() + (float)stat.durationNano() / (float)TimeUnit.SECONDS.toNanos(1L);
            float rateRx = (float)(stat.bytesReceived() * 8L) / duration;
            float rateTx = (float)(stat.bytesSent() * 8L) / duration;
            this.print("   port=%s, pktRx=%s, pktTx=%s, bytesRx=%s, bytesTx=%s, rateRx=%s, rateTx=%s, pktRxDrp=%s, pktTxDrp=%s, interval=%s", stat.portNumber(), stat.packetsReceived(), stat.packetsSent(), stat.bytesReceived(), stat.bytesSent(), String.format("%.1f", Float.valueOf(rateRx)), String.format("%.1f", Float.valueOf(rateTx)), stat.packetsRxDropped(), stat.packetsTxDropped(), String.format("%.3f", Float.valueOf(duration)));
        }
    }

    private void printPortStatsDeltaTable(DeviceId deviceId, Iterable<PortStatistics> portStats) {
        String formatDeltaTable = "|%5s | %7s | %7s |  %7s | %7s | %7s | %7s |  %7s | %7s |%9s |";
        this.print("+---------------------------------------------------------------------------------------------------+", new Object[0]);
        this.print("| DeviceId = %-86s |", deviceId);
        this.print("|---------------------------------------------------------------------------------------------------|", new Object[0]);
        this.print("|      | Receive                                | Transmit                               | Time [s] |", new Object[0]);
        this.print("| Port | Packets |  Bytes  | Rate bps |   Drop  | Packets |  Bytes  | Rate bps |   Drop  | Interval |", new Object[0]);
        this.print("|---------------------------------------------------------------------------------------------------|", new Object[0]);
        for (PortStatistics stat : DevicePortStatsCommand.sortByPort(portStats)) {
            if (this.isIrrelevant(stat) || this.nonzero && stat.isZero()) continue;
            float duration = (float)stat.durationSec() + (float)stat.durationNano() / (float)TimeUnit.SECONDS.toNanos(1L);
            float rateRx = duration > 0.0f ? (float)(stat.bytesReceived() * 8L) / duration : 0.0f;
            float rateTx = duration > 0.0f ? (float)(stat.bytesSent() * 8L) / duration : 0.0f;
            this.print("|%5s | %7s | %7s |  %7s | %7s | %7s | %7s |  %7s | %7s |%9s |", stat.portNumber(), DevicePortStatsCommand.humanReadable(stat.packetsReceived()), DevicePortStatsCommand.humanReadable(stat.bytesReceived()), DevicePortStatsCommand.humanReadableBps(rateRx), DevicePortStatsCommand.humanReadable(stat.packetsRxDropped()), DevicePortStatsCommand.humanReadable(stat.packetsSent()), DevicePortStatsCommand.humanReadable(stat.bytesSent()), DevicePortStatsCommand.humanReadableBps(rateTx), DevicePortStatsCommand.humanReadable(stat.packetsTxDropped()), String.format("%.3f", Float.valueOf(duration)));
        }
        this.print("+---------------------------------------------------------------------------------------------------+", new Object[0]);
    }

    public static String humanReadable(long bytes) {
        int unit = 1000;
        if (bytes < (long)unit) {
            return String.format("%s ", bytes);
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        Character pre = Character.valueOf("KMGTPE".charAt(exp - 1));
        return String.format("%.2f%s", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String humanReadableBps(float bps) {
        int unit = 1000;
        if (bps < (float)unit) {
            return String.format("%.0f ", Float.valueOf(bps));
        }
        int exp = (int)(Math.log(bps) / Math.log(unit));
        Character pre = Character.valueOf("KMGTPE".charAt(exp - 1));
        return String.format("%.2f%s", (double)bps / Math.pow(unit, exp), pre);
    }

    private static List<PortStatistics> sortByPort(Iterable<PortStatistics> portStats) {
        ArrayList portStatsList = Lists.newArrayList(portStats);
        portStatsList.sort(Comparator.comparing(ps -> ps.portNumber().toLong()));
        return portStatsList;
    }
}

