/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.DeviceIdCompleter;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.BasicSystemOperations;
import org.onosproject.net.device.DeviceService;

@Service
@Command(scope="onos", name="device-reboot", description="Administratively reboots a device")
public class DeviceRebootCommand
extends AbstractShellCommand {
    @Argument(index=0, name="deviceId", description="Device ID", required=true, multiValued=false)
    @Completion(value=DeviceIdCompleter.class)
    String deviceId = null;

    @Override
    protected void doExecute() {
        Device dev = DeviceRebootCommand.get(DeviceService.class).getDevice(DeviceId.deviceId((String)this.deviceId));
        if (dev == null) {
            this.print(" %s", "Device does not exist");
            return;
        }
        if (dev.is(BasicSystemOperations.class)) {
            this.print("Reboot for the device %s issued", this.deviceId);
            ((BasicSystemOperations)dev.as(BasicSystemOperations.class)).reboot().whenComplete((future, error) -> {
                if (error == null) {
                    this.print("Reboot for the device %s succeed.", this.deviceId);
                } else {
                    log.error("Exception while rebooting device " + this.deviceId, error);
                }
            });
        } else {
            log.error("Device does not support {} behaviour", (Object)BasicSystemOperations.class.getName());
        }
    }
}

