/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverAdminService;
import org.onosproject.net.driver.DriverProvider;

@Service
@Command(scope="onos", name="driver-providers", description="Lists device driver providers")
public class DriverProvidersListCommand
extends AbstractShellCommand {
    private static final String FMT = "provider=%s, drivers=%s";

    @Override
    protected void doExecute() {
        DriverAdminService service = DriverProvidersListCommand.get(DriverAdminService.class);
        service.getProviders().forEach(this::printDriverProvider);
    }

    private void printDriverProvider(DriverProvider provider) {
        this.print(FMT, provider.getClass().getName(), provider.getDrivers().stream().map(Driver::name).collect(Collectors.toSet()));
    }
}

