/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.NullCompleter;
import org.onlab.packet.Ethernet;
import org.onlab.packet.MacAddress;
import org.onlab.util.Tools;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.ConnectPointCompleter;
import org.onosproject.core.ApplicationId;
import org.onosproject.event.EventListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.PointToPointIntent;

@Service
@Command(scope="onos", name="cycle-intents", description="Installs random intents to test throughput")
public class IntentCycleCommand
extends AbstractShellCommand
implements IntentListener {
    @Argument(index=0, name="ingressDevice", description="Ingress Device/Port Description", required=true, multiValued=false)
    @Completion(value=ConnectPointCompleter.class)
    String ingressDeviceString = null;
    @Argument(index=1, name="egressDevice", description="Egress Device/Port Description", required=true, multiValued=false)
    @Completion(value=ConnectPointCompleter.class)
    String egressDeviceString = null;
    @Argument(index=2, name="numberOfIntents", description="Number of intents to install/withdraw", required=true, multiValued=false)
    @Completion(value=NullCompleter.class)
    String numberOfIntents = null;
    @Argument(index=3, name="keyOffset", description="Starting point for first key (default: 1)", required=false, multiValued=false)
    String keyOffsetStr = null;
    private IntentService service;
    private volatile long start;
    private int count;
    private int keyOffset;
    private long submitCounter = 0L;
    private AtomicLong eventCounter = new AtomicLong(0L);
    private boolean add;
    private static final EnumSet<IntentEvent.Type> IGNORE_EVENT = EnumSet.of(IntentEvent.Type.INSTALL_REQ, IntentEvent.Type.WITHDRAW_REQ);

    @Override
    protected void doExecute() {
        this.service = IntentCycleCommand.get(IntentService.class);
        DeviceId ingressDeviceId = DeviceId.deviceId((String)this.getDeviceId(this.ingressDeviceString));
        PortNumber ingressPortNumber = PortNumber.portNumber((String)this.getPortNumber(this.ingressDeviceString));
        ConnectPoint ingress = new ConnectPoint((ElementId)ingressDeviceId, ingressPortNumber);
        DeviceId egressDeviceId = DeviceId.deviceId((String)this.getDeviceId(this.egressDeviceString));
        PortNumber egressPortNumber = PortNumber.portNumber((String)this.getPortNumber(this.egressDeviceString));
        ConnectPoint egress = new ConnectPoint((ElementId)egressDeviceId, egressPortNumber);
        this.count = Integer.parseInt(this.numberOfIntents);
        this.keyOffset = this.keyOffsetStr != null ? Integer.parseInt(this.keyOffsetStr) : 1;
        this.service.addListener((EventListener)this);
        List<Intent> operations = this.generateIntents(ingress, egress);
        this.add = true;
        this.start = System.currentTimeMillis();
        while (this.start + 10000L > System.currentTimeMillis()) {
            this.submitIntents(operations);
        }
        Tools.delay((int)5000);
        this.printResults();
        this.add = false;
        this.submitIntents(operations);
        this.service.removeListener((EventListener)this);
    }

    private List<Intent> generateIntents(ConnectPoint ingress, ConnectPoint egress) {
        TrafficSelector.Builder selectorBldr = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4);
        TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
        ArrayList intents = Lists.newArrayList();
        for (long i = 0L; i < (long)this.count; ++i) {
            TrafficSelector selector = selectorBldr.matchEthSrc(MacAddress.valueOf((long)(i + (long)this.keyOffset))).build();
            intents.add(PointToPointIntent.builder().appId(this.appId()).key(Key.of((long)(i + (long)this.keyOffset), (ApplicationId)this.appId())).selector(selector).treatment(treatment).filteredIngressPoint(new FilteredConnectPoint(ingress)).filteredEgressPoint(new FilteredConnectPoint(egress)).build());
        }
        return intents;
    }

    private void submitIntents(List<Intent> intents) {
        for (Intent intent : intents) {
            if (this.add) {
                ++this.submitCounter;
                this.service.submit(intent);
                continue;
            }
            this.service.withdraw(intent);
        }
    }

    private void printResults() {
        this.print("count: %s / %s", this.eventCounter, this.submitCounter);
    }

    private String getPortNumber(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(slash + 1, deviceString.length());
    }

    private String getDeviceId(String deviceString) {
        int slash = deviceString.indexOf(47);
        if (slash <= 0) {
            return "";
        }
        return deviceString.substring(0, slash);
    }

    public synchronized void event(IntentEvent event) {
        IntentEvent.Type expected;
        if (!this.appId().equals(((Intent)event.subject()).appId())) {
            return;
        }
        IntentEvent.Type type = expected = this.add ? IntentEvent.Type.INSTALLED : IntentEvent.Type.WITHDRAWN;
        if (event.type() == expected) {
            this.eventCounter.getAndIncrement();
        } else if (IGNORE_EVENT.contains(event.type())) {
            log.info("Unexpected intent event: {}", (Object)event);
        }
    }
}

