/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.BitErrorCommand;
import org.onosproject.cli.net.ConnectPointCompleter;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.InternalConnectivity;
import org.onosproject.net.device.DeviceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Command(scope="onos", name="check-internal-connectivity", description="Check if two port of a device can be connected")
public class InternalConnectivityCommand
extends AbstractShellCommand {
    private static final Logger log = LoggerFactory.getLogger(BitErrorCommand.class);
    @Argument(index=0, name="input port", description="{DeviceID}/{PortNumber}", required=true, multiValued=false)
    @Completion(value=ConnectPointCompleter.class)
    private String input = null;
    @Argument(index=1, name="output port", description="{DeviceID}/{PortNumber}", required=true, multiValued=false)
    @Completion(value=ConnectPointCompleter.class)
    private String output = null;

    @Override
    protected void doExecute() throws Exception {
        ConnectPoint inputConnectPoint = ConnectPoint.deviceConnectPoint((String)this.input);
        ConnectPoint outputConnectPoint = ConnectPoint.deviceConnectPoint((String)this.output);
        DeviceService deviceService = InternalConnectivityCommand.get(DeviceService.class);
        DeviceId inputDeviceId = inputConnectPoint.deviceId();
        DeviceId outputDeviceId = outputConnectPoint.deviceId();
        PortNumber inputPortNumber = inputConnectPoint.port();
        PortNumber outputPortNumber = outputConnectPoint.port();
        if (!inputDeviceId.equals((Object)outputDeviceId)) {
            this.print("[ERROR] specified connect points should belong to the same device.", new Object[0]);
            return;
        }
        Device device = deviceService.getDevice(inputDeviceId);
        if (device == null || !device.is(InternalConnectivity.class)) {
            this.print("[ERROR] specified device %s does not support Internal Connectivity Behaviour.", device.toString());
            return;
        }
        InternalConnectivity internalConnectivityBehaviour = (InternalConnectivity)device.as(InternalConnectivity.class);
        if (internalConnectivityBehaviour.testConnectivity(inputPortNumber, outputPortNumber)) {
            this.print("[CONNECTIVITY ALLOWED] device %s from input-port %s to output-port %s", device.id().toString(), inputPortNumber.toString(), outputPortNumber.toString());
        } else {
            this.print("[CONNECTIVITY NOT ALLOWED] device %s from input-port %s to output-port %s", device.id().toString(), inputPortNumber.toString(), outputPortNumber.toString());
        }
    }
}

