/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.PlaceholderCompleter;
import org.onosproject.cli.net.ConnectPointCompleter;
import org.onosproject.cli.net.McastGroupCompleter;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.mcast.McastRoute;
import org.onosproject.net.mcast.MulticastRouteService;

@Service
@Command(scope="onos", name="mcast-delete", description="Delete a multicast route flow")
public class McastDeleteCommand
extends AbstractShellCommand {
    private static final String D_FORMAT_MAPPING = "Deleted the mcast route: origin=%s, group=%s, source=%s";
    private static final String U_FORMAT_MAPPING = "Updated the mcast route: origin=%s, group=%s, source=%s";
    @Argument(index=0, name="sAddr", description="IP Address of the multicast source. '*' can be used for any source (*, G) entry", required=true, multiValued=false)
    @Completion(value=PlaceholderCompleter.class)
    String sAddr = null;
    @Argument(index=1, name="gAddr", description="IP Address of the multicast group. '*' can be used to denote all groups", required=true, multiValued=false)
    @Completion(value=McastGroupCompleter.class)
    String gAddr = null;
    @Argument(index=2, name="egressList", description="Egress id/port", required=false, multiValued=true)
    @Completion(value=ConnectPointCompleter.class)
    String[] egressList = null;

    @Override
    protected void doExecute() {
        MulticastRouteService mcastRouteManager = McastDeleteCommand.get(MulticastRouteService.class);
        if ("*".equals(this.sAddr) && "*".equals(this.gAddr)) {
            mcastRouteManager.getRoutes().forEach(arg_0 -> ((MulticastRouteService)mcastRouteManager).remove(arg_0));
            return;
        }
        McastRoute mRoute = new McastRoute(IpAddress.valueOf((String)this.sAddr), IpAddress.valueOf((String)this.gAddr), McastRoute.Type.STATIC);
        if (this.egressList == null) {
            mcastRouteManager.remove(mRoute);
            this.print(D_FORMAT_MAPPING, mRoute.type(), mRoute.group(), mRoute.source());
        } else {
            for (String egress : this.egressList) {
                ConnectPoint eCp = ConnectPoint.deviceConnectPoint((String)egress);
                mcastRouteManager.removeSink(mRoute, eCp);
            }
            this.print(U_FORMAT_MAPPING, mRoute.type(), mRoute.group(), mRoute.source());
        }
    }
}

