/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.PlaceholderCompleter;
import org.onosproject.cli.net.ConnectPointCompleter;
import org.onosproject.cli.net.McastGroupCompleter;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.mcast.McastRoute;
import org.onosproject.net.mcast.MulticastRouteService;

@Service
@Command(scope="onos", name="mcast-join", description="Installs a source, multicast group flow")
public class McastJoinCommand
extends AbstractShellCommand {
    private static final String FORMAT_MAPPING = "Added the mcast route: origin=%s, group=%s, source=%s";
    @Argument(index=0, name="sAddr", description="IP Address of the multicast source. '*' can be used for any source (*, G) entry", required=true, multiValued=false)
    @Completion(value=PlaceholderCompleter.class)
    String sAddr = null;
    @Argument(index=1, name="gAddr", description="IP Address of the multicast group", required=true, multiValued=false)
    @Completion(value=McastGroupCompleter.class)
    String gAddr = null;
    @Argument(index=2, name="ingressPort", description="Ingress port of:XXXXXXXXXX/XX", required=false, multiValued=false)
    @Completion(value=ConnectPointCompleter.class)
    String ingressPort = null;
    @Argument(index=3, name="ports", description="Egress ports of:XXXXXXXXXX/XX...", required=false, multiValued=true)
    String[] ports = null;

    @Override
    protected void doExecute() {
        MulticastRouteService mcastRouteManager = McastJoinCommand.get(MulticastRouteService.class);
        McastRoute mRoute = new McastRoute(IpAddress.valueOf((String)this.sAddr), IpAddress.valueOf((String)this.gAddr), McastRoute.Type.STATIC);
        mcastRouteManager.add(mRoute);
        if (this.ingressPort != null) {
            ConnectPoint ingress = ConnectPoint.deviceConnectPoint((String)this.ingressPort);
            mcastRouteManager.addSource(mRoute, ingress);
        }
        if (this.ports != null) {
            for (String egCP : this.ports) {
                ConnectPoint egress = ConnectPoint.deviceConnectPoint((String)egCP);
                mcastRouteManager.addSink(mRoute, egress);
            }
        }
        this.printMcastRoute(mRoute);
    }

    private void printMcastRoute(McastRoute mcastRoute) {
        this.print(FORMAT_MAPPING, mcastRoute.type(), mcastRoute.group(), mcastRoute.source());
    }
}

