/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.mcast.McastRoute;
import org.onosproject.net.mcast.MulticastRouteService;

@Service
@Command(scope="onos", name="mcast-routes", description="Lists routes in the mcast route store")
public class McastRoutesListCommand
extends AbstractShellCommand {
    private static final String FORMAT_TOTAL = "   Total: %d";
    private static final String FORMAT_ROUTE = "%-1s   %-18s %-15s %s   %s";
    private static final String FORMAT_ROUTE6 = "%-1s   %-40s %-36s %s   %s";
    private static final String FORMAT_TABLE = "Table: %s";
    private static final String GROUP = "Group";
    private static final String SOURCE = "Source";
    private static final String ORIGIN = "Origin";
    private static final String SINKS = "Sinks";

    @Override
    protected void doExecute() {
        MulticastRouteService mcastService = McastRoutesListCommand.get(MulticastRouteService.class);
        Set routes = mcastService.getRoutes();
        Set ipv4Routes = routes.stream().filter(mcastRoute -> mcastRoute.group().isIp4()).collect(Collectors.toSet());
        Set ipv6Routes = routes.stream().filter(mcastRoute -> mcastRoute.group().isIp6()).collect(Collectors.toSet());
        this.print(FORMAT_TABLE, "ipv4");
        this.print(FORMAT_ROUTE, "", GROUP, SOURCE, ORIGIN, SINKS);
        ipv4Routes.stream().sorted(Comparator.comparing(McastRoute::group)).forEach(route -> {
            Set sinks = mcastService.fetchSinks(route);
            this.print(FORMAT_ROUTE, "", route.group(), route.source(), route.type(), sinks.size());
        });
        this.print(FORMAT_TOTAL, ipv4Routes.size());
        this.print("", new Object[0]);
        this.print(FORMAT_TABLE, "ipv6");
        this.print(FORMAT_ROUTE6, "", GROUP, SOURCE, ORIGIN, SINKS);
        ipv6Routes.stream().sorted(Comparator.comparing(McastRoute::group)).forEach(route -> {
            Set sinks = mcastService.fetchSinks(route);
            this.print(FORMAT_ROUTE6, "", route.group(), route.source(), route.type(), sinks.size());
        });
        this.print(FORMAT_TOTAL, ipv6Routes.size());
        this.print("", new Object[0]);
    }
}

