/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.RegionIdCompleter;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;
import org.onosproject.net.region.RegionService;
import org.onosproject.utils.Comparators;

@Service
@Command(scope="onos", name="regions", description="List Region details including membership")
public class RegionListCommand
extends AbstractShellCommand {
    private static final String FMT = "id=%s, name=%s, type=%s";
    private static final String FMT_MASTER = "  master=%s";
    @Argument(index=0, name="id", description="Region ID", required=false, multiValued=false)
    @Completion(value=RegionIdCompleter.class)
    String id = null;
    private RegionService regionService;

    @Override
    protected void doExecute() {
        this.regionService = RegionListCommand.get(RegionService.class);
        if (this.id == null) {
            for (Region region : this.getSortedRegions(this.regionService)) {
                this.printRegion(region);
            }
        } else {
            Region region = this.regionService.getRegion(RegionId.regionId((String)this.id));
            if (region == null) {
                this.error("No such region %s", this.id);
            } else {
                this.printRegion(region);
            }
        }
    }

    protected List<Region> getSortedRegions(RegionService service) {
        ArrayList regions = Lists.newArrayList((Iterable)service.getRegions());
        Collections.sort(regions, Comparators.REGION_COMPARATOR);
        return regions;
    }

    private void printRegion(Region region) {
        this.print(FMT, region.id(), region.name(), region.type());
        region.masters().forEach(m -> this.print(FMT_MASTER, m));
        this.regionService.getRegionDevices(region.id()).forEach(id -> this.print("  %s", id));
    }
}

