/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.app;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.app.ApplicationService;
import org.onosproject.app.ApplicationState;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.core.Application;
import org.onosproject.utils.Comparators;

@Service
@Command(scope="onos", name="apps", description="Lists application information")
public class ApplicationsListCommand
extends AbstractShellCommand {
    private static final String FMT = "%s id=%d, name=%s, version=%s, origin=%s, category=%s, description=%s, features=%s, featuresRepo=%s, apps=%s, permissions=%s, url=%s";
    private static final String SHORT_FMT = "%s %3d %-36s %-8s %s";
    @Option(name="-s", aliases={"--short"}, description="Show short output only", required=false, multiValued=false)
    private boolean shortOnly = false;
    @Option(name="-a", aliases={"--active"}, description="Show active only", required=false, multiValued=false)
    private boolean activeOnly = false;
    @Option(name="-n", aliases={"--name"}, description="Sort by application ID name")
    private boolean sortByName = false;
    @Option(name="-r", aliases={"--regapps"}, description="Get Registered Apps for Runtime Version")
    private boolean getRegisteredApps = false;

    @Override
    protected void doExecute() {
        ApplicationService service = ApplicationsListCommand.get(ApplicationService.class);
        ArrayList apps = this.getRegisteredApps ? Lists.newArrayList((Iterable)service.getRegisteredApplications()) : Lists.newArrayList((Iterable)service.getApplications());
        if (this.sortByName) {
            apps.sort(Comparator.comparing(app -> app.id().name()));
        } else {
            Collections.sort(apps, Comparators.APP_COMPARATOR);
        }
        if (this.outputJson()) {
            this.print("%s", this.json(service, apps));
        } else {
            for (Application app2 : apps) {
                boolean isActive;
                boolean bl = isActive = service.getState(app2.id()) == ApplicationState.ACTIVE;
                if ((!this.activeOnly || !isActive) && this.activeOnly) continue;
                if (this.shortOnly) {
                    String shortDescription = app2.title().equals(app2.id().name()) ? app2.description().replaceAll("[\\r\\n]", " ").replaceAll(" +", " ") : app2.title();
                    this.print(SHORT_FMT, isActive ? "*" : " ", app2.id().id(), app2.id().name(), app2.version(), shortDescription);
                    continue;
                }
                this.print(FMT, isActive ? "*" : " ", app2.id().id(), app2.id().name(), app2.version(), app2.origin(), app2.category(), app2.description(), app2.features(), app2.featuresRepo().map(URI::toString).orElse(""), app2.requiredApps(), app2.permissions(), app2.url());
            }
        }
    }

    private JsonNode json(ApplicationService service, List<Application> apps) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (Application app : apps) {
            boolean isActive;
            boolean bl = isActive = service.getState(app.id()) == ApplicationState.ACTIVE;
            if ((!this.activeOnly || !isActive) && this.activeOnly) continue;
            result.add((JsonNode)this.jsonForEntity(app, Application.class));
        }
        return result;
    }
}

