/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.net.TopologyCommand;
import org.onosproject.net.topology.TopologyCluster;
import org.onosproject.utils.Comparators;

@Service
@Command(scope="onos", name="topo-clusters", description="Lists all clusters in the current topology")
public class ClustersListCommand
extends TopologyCommand {
    private static final String FMT = "id=%d, devices=%d, links=%d";

    @Override
    protected void doExecute() {
        this.init();
        ArrayList clusters = Lists.newArrayList((Iterable)this.service.getClusters(this.topology));
        Collections.sort(clusters, Comparators.CLUSTER_COMPARATOR);
        if (this.outputJson()) {
            this.print("%s", this.json(clusters));
        } else {
            for (TopologyCluster cluster : clusters) {
                this.print(FMT, cluster.id().index(), cluster.deviceCount(), cluster.linkCount());
            }
        }
    }

    private JsonNode json(Iterable<TopologyCluster> clusters) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        clusters.spliterator().forEachRemaining(cluster -> result.add((JsonNode)this.jsonForEntity(cluster, TopologyCluster.class)));
        return result;
    }
}

