/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Streams;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.IntentKeyCompleter;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.Port;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortStatistics;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.intent.FlowRuleIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.ObjectiveTrackerService;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.net.intent.WorkPartitionService;
import org.onosproject.net.statistic.FlowStatisticService;

@Service
@Command(scope="onos", name="intents-diagnosis", description="Diagnosis intents")
public class IntentsDiagnosisCommand
extends AbstractShellCommand {
    @Argument(index=0, name="key", description="Intent key", required=false, multiValued=false)
    @Completion(value=IntentKeyCompleter.class)
    String key = null;
    @Option(name="-d", aliases={"--details"}, description="printing intent details", required=false, multiValued=false)
    private boolean dump = false;
    @Option(name="-l", aliases={"--link"}, description="printing local intentsByLink", required=false, multiValued=false)
    private boolean dumpIntentByLink = false;
    private static final int MAX_INTENT_PATH = 100;
    private static final String FIELD_INTENTS_BY_LINK = "intentsByLink";

    @Override
    protected void doExecute() {
        this.print("intents-diagnosis", new Object[0]);
        ServiceRefs svcRefs = this.buildServiceRefs();
        if (svcRefs == null) {
            return;
        }
        try {
            for (Intent intent : svcRefs.intentsService().getIntents()) {
                if (this.key != null && !intent.key().toString().equals(this.key)) continue;
                this.print("", new Object[0]);
                this.printIntentHdr(intent, svcRefs);
                if (intent instanceof PointToPointIntent) {
                    this.diagnosisP2Pintent((PointToPointIntent)intent, svcRefs);
                    continue;
                }
                this.print(" It doesn't support %s intent.", intent.getClass().getSimpleName());
            }
            if (this.dumpIntentByLink) {
                this.dumpIntentsByLink(svcRefs);
            }
        }
        catch (Exception e) {
            this.print("error: " + e, new Object[0]);
        }
    }

    private void printIntentHdr(Intent intent, ServiceRefs svcRefs) {
        this.print("* intent key: %s", intent.key());
        this.print(" - state: %s", svcRefs.intentsService().getIntentState(intent.key()));
        this.dump(" - leader: %s %s", svcRefs.getWorkPartitionService().getLeader((Object)intent.key(), Key::hash), svcRefs.workPartitionService.isMine((Object)intent.key(), Key::hash) ? "(Mine)" : "");
    }

    private void dumpIntentsByLink(ServiceRefs svcRefs) {
        Set<Map.Entry<LinkKey, Key>> intentsByLink = this.getIntentsByLinkSet(svcRefs);
        this.print("* intentsbylink:", new Object[0]);
        for (Map.Entry<LinkKey, Key> entry : intentsByLink) {
            this.print(" - %s, Intents: %s ", entry.getKey(), entry.getValue());
        }
    }

    private Set<Map.Entry<LinkKey, Key>> getIntentsByLinkSet(ServiceRefs svcRefs) {
        try {
            ObjectiveTrackerService objTracker = svcRefs.getObjectiveTrackerService();
            Field f = objTracker.getClass().getDeclaredField(FIELD_INTENTS_BY_LINK);
            f.setAccessible(true);
            SetMultimap intentsByLink = (SetMultimap)f.get(objTracker);
            return ImmutableSet.copyOf((Collection)intentsByLink.entries());
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            this.error("error: " + ex, new Object[0]);
            return ImmutableSet.of();
        }
    }

    private void diagnosisP2Pintent(PointToPointIntent intent, ServiceRefs svcRefs) {
        List installableIntents = svcRefs.intentsService().getInstallableIntents(intent.key());
        if (installableIntents.size() == 0) {
            this.error("NO INSTALLABLE INTENTS", new Object[0]);
            return;
        }
        HashSet<String> notSupport = new HashSet<String>();
        for (Intent installable : installableIntents) {
            if (installable instanceof FlowRuleIntent) {
                this.checkP2PFlowRuleIntent(intent, (FlowRuleIntent)installable, svcRefs);
                continue;
            }
            notSupport.add(installable.getClass().getSimpleName());
        }
        if (notSupport.size() > 0) {
            this.print(" It doesn't support %s.", notSupport);
        }
    }

    private void checkP2PFlowRuleIntent(PointToPointIntent intent, FlowRuleIntent installable, ServiceRefs svcRefs) {
        ConnectPoint endCp;
        DeviceOnIntent endDev;
        Map<DeviceId, DeviceOnIntent> devs = this.createDevicesOnP2PIntent(intent, installable);
        boolean errorOccurred = false;
        for (DeviceOnIntent dev : devs.values()) {
            if (dev.getIngressLinks().size() > 1) {
                this.error("MULTIPLE NUMBER OF INGRESS LINKs on " + dev.deviceId() + ": " + dev.getIngressLinks(), new Object[0]);
                errorOccurred = true;
            }
            if (dev.getIngressCps().size() > 1) {
                this.error("MULTIPLE NUMBER OF INGRESS CONNECT POINTs on " + dev.deviceId() + ": " + dev.getIngressCps(), new Object[0]);
                errorOccurred = true;
            }
            if (dev.getEgressLinks().size() > 1) {
                this.error("MULTIPLE NUMBER OF EGRESS LINKs: on " + dev.deviceId() + ": " + dev.getEgressLinks(), new Object[0]);
                errorOccurred = true;
            }
            if (dev.getEgressCps().size() <= 1) continue;
            this.error("MULTIPLE NUMBER OF EGRESS CONNECT POINTs: on " + dev.deviceId() + ": " + dev.getEgressCps(), new Object[0]);
            errorOccurred = true;
        }
        ConnectPoint startCp = intent.filteredIngressPoint().connectPoint();
        DeviceOnIntent startDev = devs.get(startCp.deviceId());
        if (startDev == null) {
            this.error("STARTING CONNECT POINT DEVICE: " + startCp.deviceId() + " is not on intent", new Object[0]);
            errorOccurred = true;
        }
        if ((endDev = devs.get((endCp = intent.filteredEgressPoint().connectPoint()).deviceId())) == null) {
            this.error("END CONNECT POINT DEVICE: " + endCp.deviceId() + " is not on intent", new Object[0]);
            errorOccurred = true;
        }
        if (!errorOccurred) {
            int i;
            DeviceOnIntent dev = startDev;
            for (i = 0; i < 100; ++i) {
                this.perDeviceChecking(dev, svcRefs);
                ConnectPoint egressCp = dev.getEgressCps().stream().findFirst().orElse(null);
                if (egressCp != null && Objects.equals(endCp, egressCp)) break;
                Link egressLink = dev.getEgressLinks().stream().findFirst().orElse(null);
                if (egressLink == null) {
                    this.error("INVALID EGRESS LINK & CONNECT POINT for: " + dev, new Object[0]);
                    errorOccurred = true;
                    break;
                }
                if (Objects.equals(egressLink.dst(), endCp)) break;
                dev = devs.values().stream().filter(nextDev -> Objects.equals(egressLink, nextDev.getIngressLinks().stream().findFirst().orElse(null))).findAny().orElse(null);
                if (dev != null) continue;
                this.error("FAILED TO FIND NEXT DEV for: " + dev + ", LINK: " + egressLink, new Object[0]);
                errorOccurred = true;
                break;
            }
            if (i == 100) {
                this.error("MAX INTENT PATH WAS EXCEEDED", new Object[0]);
                errorOccurred = true;
            }
        }
        if (errorOccurred) {
            this.dump("", new Object[0]);
            this.dump("ERROR OCCURRED. DO PER FLOW CHECKING", new Object[0]);
            this.perFlowRuleChecking(installable, svcRefs);
        }
        if (svcRefs.workPartitionService.isMine((Object)intent.key(), Key::hash)) {
            this.checkIntentsByLink(installable, svcRefs);
        }
    }

    private void checkIntentsByLink(FlowRuleIntent installable, ServiceRefs svcRefs) {
        Set<Map.Entry<LinkKey, Key>> intentsByLink = this.getIntentsByLinkSet(svcRefs);
        installable.resources().forEach(rsrc -> {
            if (rsrc instanceof Link) {
                Link link = (Link)rsrc;
                LinkKey linkKey = LinkKey.linkKey((Link)link);
                intentsByLink.stream().filter(entry -> Objects.equals(entry.getKey(), linkKey) && Objects.equals(entry.getValue(), installable.key())).findAny().orElseGet(() -> {
                    this.error("FAILED TO FIND LINK(" + link + ") for intents: " + installable.key(), new Object[0]);
                    return null;
                });
            }
        });
    }

    private void perDeviceChecking(DeviceOnIntent devOnIntent, ServiceRefs svcRefs) {
        List portStats = svcRefs.deviceService().getPortStatistics(devOnIntent.deviceId());
        List portDeltaStats = svcRefs.deviceService().getPortDeltaStatistics(devOnIntent.deviceId());
        this.dump("", new Object[0]);
        this.dump(" ------------------------------------------------------------------------------------------", new Object[0]);
        Device device = svcRefs.deviceService.getDevice(devOnIntent.deviceId());
        if (device == null) {
            this.error("INVALID DEVICE for " + devOnIntent.deviceId(), new Object[0]);
            return;
        }
        this.dump(" %s", this.getDeviceString(device));
        this.dump("  %s", device.annotations());
        devOnIntent.getIngressCps().stream().forEach(cp -> this.dumpCpStatistics((ConnectPoint)cp, portStats, portDeltaStats, "INGRESS", svcRefs));
        Stream flowEntries = Streams.stream((Iterable)svcRefs.flowService.getFlowEntries(devOnIntent.deviceId()));
        devOnIntent.getFlowRules().stream().forEach(intentFlowRule -> {
            FlowEntry matchedEntry = flowEntries.filter(entry -> Objects.equals(intentFlowRule.id(), entry.id())).findFirst().orElse(null);
            if (matchedEntry == null) {
                this.error("FAILED TO FIND FLOW ENTRY: for " + intentFlowRule, new Object[0]);
                return;
            }
            if (Objects.equals(intentFlowRule.selector(), matchedEntry.selector()) && Objects.equals(intentFlowRule.treatment(), matchedEntry.treatment())) {
                this.dumpFlowEntry(matchedEntry, "FLOW ENTRY");
                return;
            }
            this.error("INSTALLABLE-FLOW ENTRY mismatch", new Object[0]);
            this.dumpFlowRule((FlowRule)intentFlowRule, "INSTALLABLE");
            this.dumpFlowEntry(matchedEntry, "FLOW ENTRY");
        });
        devOnIntent.getEgressCps().stream().forEach(cp -> this.dumpCpStatistics((ConnectPoint)cp, portStats, portDeltaStats, "EGRESS", svcRefs));
    }

    private void perFlowRuleChecking(FlowRuleIntent installable, ServiceRefs svcRefs) {
        installable.flowRules().forEach(flowrule -> {
            DeviceId devId = flowrule.deviceId();
            if (devId == null) {
                this.error("INVALID DEVICE ID for " + flowrule, new Object[0]);
                return;
            }
            Device dev = svcRefs.deviceService.getDevice(devId);
            if (dev == null) {
                this.error("INVALID DEVICE for " + flowrule, new Object[0]);
                return;
            }
            this.dump("", new Object[0]);
            this.dump(" ------------------------------------------------------------------------------------------", new Object[0]);
            this.dump(" %s", this.getDeviceString(dev));
            this.dump("  %s", dev.annotations());
            svcRefs.flowService().getFlowEntries(devId).forEach(entry -> {
                this.dumpFlowRule((FlowRule)flowrule, "INSTALLABLE");
                this.dumpFlowEntry((FlowEntry)entry, "FLOW ENTRY");
                if (!flowrule.selector().equals(entry.selector())) {
                    return;
                }
                if (flowrule.id().equals((Object)entry.id()) && flowrule.treatment().equals(entry.treatment())) {
                    this.dumpFlowEntry((FlowEntry)entry, "FLOW ENTRY");
                    return;
                }
                this.error("INSTALLABLE-FLOW ENTRY mismatch", new Object[0]);
            });
        });
    }

    private Map<DeviceId, DeviceOnIntent> createDevicesOnP2PIntent(PointToPointIntent intent, FlowRuleIntent flowRuleIntent) {
        ConnectPoint endCp;
        DeviceOnIntent endDev;
        HashMap<DeviceId, DeviceOnIntent> devMap = new HashMap<DeviceId, DeviceOnIntent>();
        flowRuleIntent.resources().forEach(rsrc -> {
            if (rsrc instanceof Link) {
                Link link = (Link)rsrc;
                ConnectPoint srcCp = link.src();
                ConnectPoint dstCp = link.dst();
                try {
                    DeviceOnIntent dev = devMap.computeIfAbsent(srcCp.deviceId(), DeviceOnIntent::new);
                    dev.addEgressLink(link);
                    dev = devMap.computeIfAbsent(dstCp.deviceId(), DeviceOnIntent::new);
                    dev.addIngressLink(link);
                }
                catch (IllegalStateException e) {
                    this.print("error: " + e, new Object[0]);
                }
            }
        });
        ConnectPoint startCp = intent.filteredIngressPoint().connectPoint();
        DeviceOnIntent startDev = devMap.computeIfAbsent(startCp.deviceId(), DeviceOnIntent::new);
        if (!startDev.hasIngressCp(startCp)) {
            startDev.addIngressCp(startCp);
        }
        if (!(endDev = devMap.computeIfAbsent((endCp = intent.filteredEgressPoint().connectPoint()).deviceId(), DeviceOnIntent::new)).hasEgressCp(endCp)) {
            endDev.addEgessCp(endCp);
        }
        flowRuleIntent.flowRules().forEach(flowRule -> {
            DeviceId devId = flowRule.deviceId();
            if (devId == null) {
                this.error("INVALID DEVICE ID for " + flowRule, new Object[0]);
                return;
            }
            DeviceOnIntent dev = (DeviceOnIntent)devMap.get(devId);
            if (dev == null) {
                this.error("DEVICE(" + devId + ") IS NOT ON INTENTS LINKS", new Object[0]);
                return;
            }
            dev.addFlowRule((FlowRule)flowRule);
        });
        return devMap;
    }

    private String getDeviceString(Device dev) {
        StringBuilder buf = new StringBuilder();
        if (dev != null) {
            buf.append(String.format("Device: %s, ", dev.id()));
            buf.append(String.format("%s, ", dev.type()));
            buf.append(String.format("%s, ", dev.manufacturer()));
            buf.append(String.format("%s, ", dev.hwVersion()));
            buf.append(String.format("%s, ", dev.swVersion()));
            if (dev instanceof DefaultDevice) {
                String channelId;
                DefaultDevice dfltDev = (DefaultDevice)dev;
                if (dfltDev.driver() != null) {
                    buf.append(String.format("%s, ", dfltDev.driver().name()));
                }
                if ((channelId = dfltDev.annotations().value("channelId")) != null) {
                    buf.append(String.format("%s, ", channelId));
                }
            }
        }
        return buf.toString();
    }

    private void dumpFlowRule(FlowRule rule, String hdr) {
        this.dump("  " + hdr + ":", new Object[0]);
        this.dump("   - id=%s, priority=%d", rule.id(), rule.priority());
        this.dump("   - %s", rule.selector());
        this.dump("   - %s", rule.treatment());
    }

    private void dumpFlowEntry(FlowEntry entry, String hdr) {
        this.dumpFlowRule((FlowRule)entry, hdr);
        this.dump("   - packets=%d", entry.packets());
    }

    private void dumpCpStatistics(ConnectPoint cp, Collection<PortStatistics> devPortStats, Collection<PortStatistics> devPortDeltaStats, String direction, ServiceRefs svcs) {
        if (cp == null) {
            return;
        }
        this.dump("  %s:", direction);
        if (cp.port().isLogical()) {
            this.dump("   - logical: device: %s, port: %s", cp.deviceId(), cp.port());
            return;
        }
        Port port = svcs.deviceService.getPort(cp.deviceId(), cp.port());
        if (port == null) {
            return;
        }
        try {
            devPortStats.stream().filter(stat -> stat.portNumber().equals((Object)cp.port())).forEach(stat -> this.dump("   - stat   : %s:", this.getPortStatStr((PortStatistics)stat, port)));
        }
        catch (IllegalStateException e) {
            this.error("error: " + e, new Object[0]);
            return;
        }
        try {
            devPortDeltaStats.stream().filter(stat -> stat.portNumber().equals((Object)cp.port())).forEach(stat -> this.dump("   - delta  : %s:", this.getPortStatStr((PortStatistics)stat, port)));
        }
        catch (IllegalStateException e) {
            this.error("error: " + e, new Object[0]);
        }
    }

    private void dump(String format, Object ... args) {
        if (this.dump) {
            this.print(format, args);
        }
    }

    private String getPortStatStr(PortStatistics stat, Port port) {
        String portName = port.annotations().value("portName");
        return String.format("port: %s(%s), ", stat.portNumber(), portName) + String.format("enabled: %b, ", port.isEnabled()) + String.format("pktRx: %d, ", stat.packetsReceived()) + String.format("pktTx: %d, ", stat.packetsSent()) + String.format("pktRxErr: %d, ", stat.packetsRxErrors()) + String.format("pktTxErr: %d, ", stat.packetsTxErrors()) + String.format("pktRxDrp: %d, ", stat.packetsRxDropped()) + String.format("pktTxDrp: %d", stat.packetsTxDropped());
    }

    private ServiceRefs buildServiceRefs() {
        IntentService intentsService = IntentsDiagnosisCommand.get(IntentService.class);
        if (intentsService == null) {
            return null;
        }
        DeviceService deviceService = IntentsDiagnosisCommand.get(DeviceService.class);
        if (deviceService == null) {
            return null;
        }
        FlowStatisticService flowStatsService = IntentsDiagnosisCommand.get(FlowStatisticService.class);
        if (flowStatsService == null) {
            return null;
        }
        FlowRuleService flowService = IntentsDiagnosisCommand.get(FlowRuleService.class);
        if (flowService == null) {
            return null;
        }
        WorkPartitionService workPartitionService = IntentsDiagnosisCommand.get(WorkPartitionService.class);
        if (workPartitionService == null) {
            return null;
        }
        ObjectiveTrackerService objectiveTrackerService = IntentsDiagnosisCommand.get(ObjectiveTrackerService.class);
        if (objectiveTrackerService == null) {
            return null;
        }
        return new ServiceRefs(intentsService, deviceService, flowService, workPartitionService, objectiveTrackerService);
    }

    private static final class ServiceRefs {
        private IntentService intentsService;
        private DeviceService deviceService;
        private FlowRuleService flowService;
        private WorkPartitionService workPartitionService;
        private ObjectiveTrackerService objectiveTrackerService;

        private ServiceRefs(IntentService intentsService, DeviceService deviceService, FlowRuleService flowService, WorkPartitionService workPartitionService, ObjectiveTrackerService objectiveTrackerService) {
            this.intentsService = intentsService;
            this.deviceService = deviceService;
            this.flowService = flowService;
            this.workPartitionService = workPartitionService;
            this.objectiveTrackerService = objectiveTrackerService;
        }

        public IntentService intentsService() {
            return this.intentsService;
        }

        public DeviceService deviceService() {
            return this.deviceService;
        }

        public FlowRuleService flowService() {
            return this.flowService;
        }

        public WorkPartitionService getWorkPartitionService() {
            return this.workPartitionService;
        }

        public ObjectiveTrackerService getObjectiveTrackerService() {
            return this.objectiveTrackerService;
        }
    }

    private static class DeviceOnIntent {
        private final DeviceId devId;
        private Collection<Link> ingressLinks = new ArrayList<Link>();
        private Collection<Link> egressLinks = new ArrayList<Link>();
        private Collection<ConnectPoint> ingressCps = new ArrayList<ConnectPoint>();
        private Collection<ConnectPoint> egressCps = new ArrayList<ConnectPoint>();
        private Collection<FlowRule> flowRules = new ArrayList<FlowRule>();

        public DeviceOnIntent(DeviceId devId) {
            this.devId = devId;
        }

        public DeviceId deviceId() {
            return this.devId;
        }

        public Collection<Link> getIngressLinks() {
            return this.ingressLinks;
        }

        public Collection<Link> getEgressLinks() {
            return this.egressLinks;
        }

        public void addIngressLink(Link link) {
            this.ingressLinks.add(link);
            this.addIngressCp(link.dst());
        }

        public void addEgressLink(Link link) {
            this.egressLinks.add(link);
            this.addEgessCp(link.src());
        }

        public void addIngressCp(ConnectPoint cp) {
            this.ingressCps.add(cp);
        }

        public void addEgessCp(ConnectPoint cp) {
            this.egressCps.add(cp);
        }

        public boolean hasIngressCp(ConnectPoint cp) {
            return this.ingressCps.stream().anyMatch(icp -> Objects.equals(icp, cp));
        }

        public boolean hasEgressCp(ConnectPoint cp) {
            return this.egressCps.stream().anyMatch(ecp -> Objects.equals(ecp, cp));
        }

        public Collection<ConnectPoint> getIngressCps() {
            return this.ingressCps;
        }

        public Collection<ConnectPoint> getEgressCps() {
            return this.egressCps;
        }

        public Collection<FlowRule> getFlowRules() {
            return this.flowRules;
        }

        public void addFlowRule(FlowRule flowRule) {
            this.flowRules.add(flowRule);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("devId", (Object)this.devId).add("ingressLinks", this.ingressLinks).add("egressLinks", this.egressLinks).add("flowRules", this.flowRules).toString();
        }
    }
}

