/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.base.Strings;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.DeviceIdCompleter;
import org.onosproject.core.CoreService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.DefaultMeterRequest;
import org.onosproject.net.meter.MeterCellId;
import org.onosproject.net.meter.MeterId;
import org.onosproject.net.meter.MeterRequest;
import org.onosproject.net.meter.MeterScope;
import org.onosproject.net.meter.MeterService;
import org.onosproject.net.pi.model.PiMeterId;
import org.onosproject.net.pi.runtime.PiMeterCellId;

@Service
@Command(scope="onos", name="meter-remove", description="Removes a meter from a device (currently for testing)")
public class MeterRemoveCommand
extends AbstractShellCommand {
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    @Completion(value=DeviceIdCompleter.class)
    private String uri = null;
    @Argument(index=1, name="index", description="Index", required=true, multiValued=false)
    private String indexString = null;
    @Option(name="-sc", aliases={"--scope"}, description="Scope", required=false, multiValued=false)
    private String scopeString = null;
    private final String appId = "org.onosproject.cli.meterCmd";

    @Override
    protected void doExecute() {
        MeterService service = MeterRemoveCommand.get(MeterService.class);
        CoreService coreService = MeterRemoveCommand.get(CoreService.class);
        DeviceId deviceId = DeviceId.deviceId((String)this.uri);
        MeterScope scope = MeterScope.globalScope();
        if (!Strings.isNullOrEmpty((String)this.scopeString)) {
            scope = MeterScope.of((String)this.scopeString);
        }
        long index = Long.parseLong(this.indexString);
        Object meterCellId = scope.equals((Object)MeterScope.globalScope()) ? MeterId.meterId((long)index) : PiMeterCellId.ofIndirect((PiMeterId)PiMeterId.of((String)((String)scope.id())), (long)index);
        MeterRequest.Builder builder = DefaultMeterRequest.builder().forDevice(deviceId).fromApp(coreService.registerApplication("org.onosproject.cli.meterCmd"));
        MeterRequest meterRequest = builder.remove();
        service.withdraw(builder.remove(), (MeterCellId)meterCellId);
        log.info("Requested meter {} removal: {}", (Object)meterCellId.toString(), (Object)meterRequest.toString());
        this.print("Requested meter %s removal: %s", meterCellId.toString(), meterRequest.toString());
    }
}

