/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.base.Strings;
import java.util.Collection;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.DeviceIdCompleter;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterCellId;
import org.onosproject.net.meter.MeterId;
import org.onosproject.net.meter.MeterScope;
import org.onosproject.net.meter.MeterService;
import org.onosproject.net.pi.model.PiMeterId;
import org.onosproject.net.pi.runtime.PiMeterCellId;

@Service
@Command(scope="onos", name="meters", description="Shows meters")
public class MetersListCommand
extends AbstractShellCommand {
    @Argument(index=0, name="uri", description="Device ID", required=false, multiValued=false)
    @Completion(value=DeviceIdCompleter.class)
    String uri = null;
    @Argument(index=1, name="index", description="Index", required=false, multiValued=false)
    private String indexString = null;
    @Option(name="-sc", aliases={"--scope"}, description="Scope", required=false, multiValued=false)
    private String scopeString = null;
    MeterScope meterScope;
    Long index;
    MeterCellId meterCellId;

    @Override
    protected void doExecute() {
        if (!Strings.isNullOrEmpty((String)this.scopeString)) {
            this.meterScope = MeterScope.of((String)this.scopeString);
        }
        if (!Strings.isNullOrEmpty((String)this.indexString)) {
            this.index = Long.parseLong(this.indexString);
            if (this.meterScope == null) {
                this.meterScope = MeterScope.globalScope();
            }
        }
        if (this.index != null) {
            if (this.meterScope != null && this.meterScope.equals((Object)MeterScope.globalScope())) {
                this.meterCellId = MeterId.meterId((long)this.index);
            } else if (this.meterScope != null) {
                this.meterCellId = PiMeterCellId.ofIndirect((PiMeterId)PiMeterId.of((String)((String)this.meterScope.id())), (long)this.index);
            }
        }
        MeterService service = MetersListCommand.get(MeterService.class);
        if (Strings.isNullOrEmpty((String)this.uri)) {
            Collection meters = service.getAllMeters();
            this.printMeters(meters);
        } else if (this.meterCellId != null) {
            Meter m = service.getMeter(DeviceId.deviceId((String)this.uri), this.meterCellId);
            if (m != null) {
                this.print("%s", m);
            } else {
                this.error("Meter %s not found for device %s", this.meterCellId, this.uri);
            }
        } else if (this.meterScope != null) {
            Collection meters = service.getMeters(DeviceId.deviceId((String)this.uri), this.meterScope);
            this.printMeters(meters);
        } else {
            Collection meters = service.getMeters(DeviceId.deviceId((String)this.uri));
            this.printMeters(meters);
        }
    }

    private void printMeters(Collection<Meter> meters) {
        meters.forEach(m -> this.print(" %s", m));
    }
}

