/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Collection;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.service.StorageAdminService;

@Service
@Command(scope="onos", name="transactions", description="Utility for listing pending/inprogress transactions")
public class TransactionsCommand
extends AbstractShellCommand {
    private JsonNode json(Collection<TransactionId> transactionIds) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode txns = mapper.createArrayNode();
        transactionIds.forEach(id -> txns.add(id.toString()));
        return txns;
    }

    @Override
    protected void doExecute() {
        StorageAdminService storageAdminService = TransactionsCommand.get(StorageAdminService.class);
        Collection transactionIds = storageAdminService.getPendingTransactions();
        if (this.outputJson()) {
            this.print("%s", this.json(transactionIds));
        } else {
            transactionIds.forEach(id -> this.print("%s", id.toString()));
        }
    }
}

