/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cluster.ClusterAdminService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.core.Version;
import org.onosproject.utils.Comparators;

@Service
@Command(scope="onos", name="nodes", description="Lists all controller cluster nodes")
public class NodesListCommand
extends AbstractShellCommand {
    private static final String FMT = "id=%s, address=%s:%s, state=%s, version=%s, updated=%s %s";

    @Override
    protected void doExecute() {
        ClusterAdminService service = NodesListCommand.get(ClusterAdminService.class);
        ArrayList nodes = Lists.newArrayList((Iterable)service.getNodes());
        Collections.sort(nodes, Comparators.NODE_COMPARATOR);
        if (this.outputJson()) {
            this.print("%s", this.json(service, nodes));
        } else {
            ControllerNode self = service.getLocalNode();
            for (ControllerNode node : nodes) {
                String timeAgo = service.localStatus(node.id());
                Version version = service.getVersion(node.id());
                this.print(FMT, node.id(), node.ip(), node.tcpPort(), service.getState(node.id()), version == null ? "unknown" : version, timeAgo, node.equals(self) ? "*" : "");
            }
        }
    }

    private JsonNode json(ClusterAdminService service, List<ControllerNode> nodes) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        ControllerNode self = service.getLocalNode();
        for (ControllerNode node : nodes) {
            ControllerNode.State nodeState = service.getState(node.id());
            Version nodeVersion = service.getVersion(node.id());
            IpAddress nodeIp = node.ip();
            ObjectNode newNode = mapper.createObjectNode().put("id", node.id().toString()).put("ip", nodeIp != null ? nodeIp.toString() : node.host()).put("tcpPort", node.tcpPort()).put("self", node.equals(self));
            if (nodeState != null) {
                newNode.put("state", nodeState.toString());
            }
            if (nodeVersion != null) {
                newNode.put("version", nodeVersion.toString());
            }
            result.add((JsonNode)newNode);
        }
        return result;
    }
}

