/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.ConnectPointCompleter;
import org.onosproject.cli.net.completer.AnnotationKeysCompleter;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.PortAnnotationConfig;
import org.onosproject.net.device.DeviceService;

@Service
@Command(scope="onos", name="annotate-port", description="Annotates port entities")
public class AnnotatePortCommand
extends AbstractShellCommand {
    @Argument(index=0, name="port", description="Device Port", required=true)
    @Completion(value=ConnectPointCompleter.class)
    String port = null;
    @Argument(index=1, name="key", description="Annotation key", required=false)
    @Completion(value=AnnotationKeysCompleter.class)
    String key = null;
    @Argument(index=2, name="value", description="Annotation value (null to remove)", required=false)
    String value = null;
    @Option(name="--remove-config", description="Remove annotation config")
    private boolean removeCfg = false;

    @Override
    protected void doExecute() {
        DeviceService deviceService = AnnotatePortCommand.get(DeviceService.class);
        NetworkConfigService netcfgService = AnnotatePortCommand.get(NetworkConfigService.class);
        ConnectPoint connectPoint = ConnectPoint.deviceConnectPoint((String)this.port);
        if (deviceService.getPort(connectPoint) == null) {
            this.print("Port %s does not exist.", this.port);
            return;
        }
        if (this.removeCfg && this.key == null) {
            netcfgService.removeConfig((Object)connectPoint, PortAnnotationConfig.class);
            this.print("Annotation Config about %s removed", connectPoint);
            return;
        }
        if (this.key == null) {
            this.print("[ERROR] Annotation key not specified.", new Object[0]);
            return;
        }
        PortAnnotationConfig cfg = (PortAnnotationConfig)netcfgService.addConfig((Object)connectPoint, PortAnnotationConfig.class);
        if (this.removeCfg) {
            cfg.annotation(this.key);
        } else {
            cfg.annotation(this.key, this.value);
        }
        cfg.apply();
    }
}

