/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.NodeIdCompleter;
import org.onosproject.cli.net.RegionIdCompleter;
import org.onosproject.cli.net.RegionTypeCompleter;
import org.onosproject.cluster.NodeId;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionAdminService;
import org.onosproject.net.region.RegionId;
import org.onosproject.net.region.RegionService;

@Service
@Command(scope="onos", name="region-update", description="Updates an existing region.")
public class RegionUpdateCommand
extends AbstractShellCommand {
    private static final BiMap<String, Region.Type> REGION_TYPE_MAP = HashBiMap.create();
    @Argument(index=0, name="id", description="Region ID", required=true, multiValued=false)
    @Completion(value=RegionIdCompleter.class)
    String id = null;
    @Argument(index=1, name="name", description="Region Name", required=true, multiValued=false)
    String name = null;
    @Argument(index=2, name="type", description="Region Type (CONTINENT|COUNTRY|METRO|CAMPUS|BUILDING|FLOOR|ROOM|RACK|LOGICAL_GROUP)", required=true, multiValued=false)
    @Completion(value=RegionTypeCompleter.class)
    String type = null;
    @Argument(index=3, name="masters", description="Region Master, a set of nodeIds should be split with '/' delimiter (e.g., 1 2 3 / 4 5 6)", required=true, multiValued=true)
    @Completion(value=NodeIdCompleter.class)
    List<String> masterArgs = null;

    @Override
    protected void doExecute() {
        RegionService regionService = RegionUpdateCommand.get(RegionService.class);
        RegionAdminService regionAdminService = RegionUpdateCommand.get(RegionAdminService.class);
        RegionId regionId = RegionId.regionId((String)this.id);
        if (regionService.getRegion(regionId) == null) {
            this.print("The region with id %s does not exist.", regionId);
            return;
        }
        ArrayList masters = Lists.newArrayList();
        HashSet nodeIds = Sets.newHashSet();
        for (String masterArg : this.masterArgs) {
            if ("/".equals(masterArg)) {
                masters.add(nodeIds);
                nodeIds = Sets.newHashSet();
                continue;
            }
            nodeIds.add(NodeId.nodeId((String)masterArg));
        }
        masters.add(nodeIds);
        regionAdminService.updateRegion(regionId, this.name, (Region.Type)REGION_TYPE_MAP.get((Object)this.type), (List)masters);
        this.print("Region with id %s is successfully updated.", regionId);
    }

    static {
        for (Region.Type t : Region.Type.values()) {
            REGION_TYPE_MAP.put((Object)t.name(), (Object)t);
        }
    }
}

