/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Set;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cluster.ClusterMetadataService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.core.CoreService;
import org.onosproject.core.Version;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.topology.TopologyService;

@Service
@Command(scope="onos", name="summary", description="Provides summary of ONOS model")
public class SummaryCommand
extends AbstractShellCommand {
    private long activeNodes(Set<ControllerNode> nodes) {
        ClusterService clusterService = SummaryCommand.get(ClusterService.class);
        return nodes.stream().map(node -> clusterService.getState(node.id())).filter(nodeState -> nodeState.isActive()).count();
    }

    @Override
    protected void doExecute() {
        IpAddress nodeIp = SummaryCommand.get(ClusterService.class).getLocalNode().ip();
        Version version = SummaryCommand.get(CoreService.class).version();
        long numNodes = this.activeNodes(SummaryCommand.get(ClusterService.class).getNodes());
        int numDevices = SummaryCommand.get(DeviceService.class).getDeviceCount();
        int numLinks = SummaryCommand.get(LinkService.class).getLinkCount();
        int numHosts = SummaryCommand.get(HostService.class).getHostCount();
        int numScc = SummaryCommand.get(TopologyService.class).currentTopology().clusterCount();
        int numFlows = SummaryCommand.get(FlowRuleService.class).getFlowRuleCount();
        long numIntents = SummaryCommand.get(IntentService.class).getIntentCount();
        String clusterId = SummaryCommand.get(ClusterMetadataService.class).getClusterMetadata().getName();
        if (this.outputJson()) {
            this.print("%s", new ObjectMapper().createObjectNode().put("node", nodeIp.toString()).put("version", version.toString()).put("clusterId", clusterId).put("nodes", numNodes).put("devices", numDevices).put("links", numLinks).put("hosts", numHosts).put("SCC(s)", numScc).put("flows", numFlows).put("intents", numIntents));
        } else {
            this.print("node=%s, version=%s clusterId=%s", nodeIp, version, clusterId);
            this.print("nodes=%d, devices=%d, links=%d, hosts=%d, SCC(s)=%s, flows=%d, intents=%d", numNodes, numDevices, numLinks, numHosts, numScc, numFlows, numIntents);
        }
    }
}

