/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.BitErrorCommand;
import org.onosproject.cli.net.ConnectPointCompleter;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.InternalConnectivity;
import org.onosproject.net.device.DeviceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Command(scope="onos", name="get-output-ports", description="Lists possible output ports to which a given input port can be internally connected on a single device")
public class GetInternalConnectivityOutputPortsCommand
extends AbstractShellCommand {
    private static final Logger log = LoggerFactory.getLogger(BitErrorCommand.class);
    @Argument(index=0, name="input port", description="{DeviceID}/{PortNumber}", required=true, multiValued=false)
    @Completion(value=ConnectPointCompleter.class)
    private String input = null;

    @Override
    protected void doExecute() throws Exception {
        ConnectPoint inputConnectPoint = ConnectPoint.deviceConnectPoint((String)this.input);
        DeviceService deviceService = GetInternalConnectivityOutputPortsCommand.get(DeviceService.class);
        DeviceId inputDeviceId = inputConnectPoint.deviceId();
        PortNumber inputPortNumber = inputConnectPoint.port();
        Device device = deviceService.getDevice(inputDeviceId);
        if (device == null || !device.is(InternalConnectivity.class)) {
            this.print("[ERROR] specified device %s does not support Internal Connectivity Behaviour.", device.toString());
            return;
        }
        InternalConnectivity internalConnectivityBehaviour = (InternalConnectivity)device.as(InternalConnectivity.class);
        Set outputPorts = internalConnectivityBehaviour.getOutputPorts(inputPortNumber);
        List outputPortsList = outputPorts.stream().sorted((a, b) -> (int)(a.toLong() - b.toLong())).collect(Collectors.toList());
        if (outputPorts.isEmpty()) {
            this.print("[POSSIBLE OUTPUT PORTS] None!", new Object[0]);
        } else {
            this.print("[POSSIBLE OUTPUT PORTS] " + outputPortsList.toString(), new Object[0]);
        }
    }
}

