/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.Set;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.DeviceIdCompleter;
import org.onosproject.core.CoreService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.DefaultBand;
import org.onosproject.net.meter.DefaultMeterRequest;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterRequest;
import org.onosproject.net.meter.MeterScope;
import org.onosproject.net.meter.MeterService;

@Service
@Command(scope="onos", name="meter-add", description="Adds a meter to a device (currently for testing)")
public class MeterAddCommand
extends AbstractShellCommand {
    private Meter.Unit unit;
    private Set<Band> bands = new HashSet<Band>();
    private MeterScope scope;
    private Long index;
    @Option(name="-bd", aliases={"--bandDrop"}, description="Assign band DROP to this meter", required=false, multiValued=false)
    private boolean hasBandDrop = false;
    @Option(name="-br", aliases={"--bandRemark"}, description="Assign band REMARK to this meter", required=false, multiValued=false)
    private boolean hasBandRemark = false;
    @Option(name="-by", aliases={"--bandYel"}, description="Assign band MARK_YELLOW to this meter", required=false, multiValued=false)
    private boolean hasBandYel = false;
    @Option(name="-bre", aliases={"--bandRed"}, description="Assign band MARK_RED to this meter", required=false, multiValued=false)
    private boolean hasBandRed = false;
    @Option(name="-up", aliases={"--unitPkts"}, description="Assign unit Packets per Second to this meter", required=false, multiValued=false)
    private boolean hasPkts = false;
    @Option(name="-uk", aliases={"--unitKbps"}, description="Assign unit Kilobits per Second to this meter", required=false, multiValued=false)
    private boolean hasKbps = false;
    @Option(name="-ub", aliases={"--unitBytes"}, description="Assign unit Bytes per Second to this meter", required=false, multiValued=false)
    private boolean hasBytes = false;
    @Option(name="-ib", aliases={"--isBurst"}, description="Set meter applicable only to burst", required=false, multiValued=false)
    private boolean isBurst = false;
    @Option(name="-b", aliases={"--bandwidth"}, description="Bandwidth", required=false, multiValued=true)
    private String[] bandwidthString = null;
    @Option(name="-bs", aliases={"--burstSize"}, description="Burst size", required=false, multiValued=true)
    private String[] burstSizeString = null;
    @Option(name="-sc", aliases={"--scope"}, description="Scope", required=false, multiValued=false)
    private String scopeString = null;
    @Option(name="-id", aliases={"--index"}, description="Index", required=false, multiValued=false)
    private String indexString = null;
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    @Completion(value=DeviceIdCompleter.class)
    private String uri = null;
    private final String appId = "org.onosproject.cli.meterCmd";

    private void checkOptions() {
        Band band;
        int i;
        if (this.hasPkts) {
            this.unit = Meter.Unit.PKTS_PER_SEC;
        } else if (this.hasKbps) {
            this.unit = Meter.Unit.KB_PER_SEC;
        } else if (this.hasBytes) {
            this.unit = Meter.Unit.BYTES_PER_SEC;
        }
        int numBands = 0;
        if (this.hasBandDrop) {
            ++numBands;
        }
        if (this.hasBandRemark) {
            ++numBands;
        }
        if (this.hasBandYel) {
            ++numBands;
        }
        if (this.hasBandRed) {
            ++numBands;
        }
        long[] rates = new long[numBands];
        long[] bursts = new long[numBands];
        if (this.bandwidthString != null && this.bandwidthString.length == numBands && this.burstSizeString != null && this.burstSizeString.length == numBands) {
            for (i = 0; i < this.bandwidthString.length; ++i) {
                rates[i] = 500L;
                bursts[i] = 0L;
                if (!Strings.isNullOrEmpty((String)this.bandwidthString[i])) {
                    rates[i] = Long.parseLong(this.bandwidthString[i]);
                }
                if (Strings.isNullOrEmpty((String)this.burstSizeString[i])) continue;
                bursts[i] = Long.parseLong(this.burstSizeString[i]);
            }
        } else if (this.bandwidthString != null && this.bandwidthString.length < numBands && this.burstSizeString != null && this.burstSizeString.length < numBands) {
            for (i = 0; i < numBands; ++i) {
                rates[i] = 500L;
                bursts[i] = 0L;
                if (i < this.bandwidthString.length && !Strings.isNullOrEmpty((String)this.bandwidthString[i])) {
                    rates[i] = Long.parseLong(this.bandwidthString[i]);
                }
                if (i >= this.burstSizeString.length || Strings.isNullOrEmpty((String)this.burstSizeString[i])) continue;
                bursts[i] = Long.parseLong(this.burstSizeString[i]);
            }
        }
        i = 0;
        if (this.hasBandDrop) {
            band = DefaultBand.builder().ofType(Band.Type.DROP).withRate(rates[i]).burstSize(bursts[i]).build();
            this.bands.add(band);
            ++i;
        }
        if (this.hasBandRemark) {
            band = DefaultBand.builder().ofType(Band.Type.REMARK).withRate(rates[i]).burstSize(bursts[i]).build();
            this.bands.add(band);
            ++i;
        }
        if (this.hasBandYel) {
            band = DefaultBand.builder().ofType(Band.Type.MARK_YELLOW).withRate(rates[i]).burstSize(bursts[i]).build();
            this.bands.add(band);
            ++i;
        }
        if (this.hasBandRed) {
            band = DefaultBand.builder().ofType(Band.Type.MARK_RED).withRate(rates[i]).burstSize(bursts[i]).build();
            this.bands.add(band);
        }
        if (this.bands.size() == 0) {
            band = DefaultBand.builder().ofType(Band.Type.DROP).withRate(500L).burstSize(0L).build();
            this.bands.add(band);
        }
        if (!Strings.isNullOrEmpty((String)this.scopeString)) {
            this.scope = MeterScope.of((String)this.scopeString);
        }
        if (!Strings.isNullOrEmpty((String)this.indexString) && this.scope != null) {
            this.index = Long.parseLong(this.indexString);
        }
    }

    @Override
    protected void doExecute() {
        MeterService service = MeterAddCommand.get(MeterService.class);
        CoreService coreService = MeterAddCommand.get(CoreService.class);
        DeviceId deviceId = DeviceId.deviceId((String)this.uri);
        this.checkOptions();
        MeterRequest.Builder builder = DefaultMeterRequest.builder().forDevice(deviceId).fromApp(coreService.registerApplication("org.onosproject.cli.meterCmd")).withUnit(this.unit).withBands(this.bands);
        if (this.isBurst) {
            builder = builder.burst();
        }
        if (this.scope != null) {
            builder = builder.withScope(this.scope);
        }
        if (this.index != null) {
            builder = builder.withIndex(this.index);
        }
        MeterRequest request = builder.add();
        Meter m = service.submit(request);
        log.info("Requested meter with cellId {}: {}", (Object)m.meterCellId().toString(), (Object)m.toString());
        this.print("Requested meter with cellId %s: %s", m.meterCellId().toString(), m.toString());
    }
}

