/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.device.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.onlab.packet.ChassisId;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.mastership.MastershipServiceAdapter;
import org.onosproject.mastership.MastershipTerm;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceClockService;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceStore;
import org.onosproject.net.device.DeviceStoreDelegate;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.cluster.StaticClusterService;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.ClusterMessageHandler;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.device.impl.DeviceClockManager;
import org.onosproject.store.device.impl.GossipDeviceStore;
import org.onosproject.store.device.impl.GossipDeviceStoreMessageSubjects;
import org.onosproject.store.device.impl.InternalDeviceEvent;
import org.onosproject.store.device.impl.InternalPortStatusEvent;

public class GossipDeviceStoreTest {
    private static final ProviderId PID = new ProviderId("of", "foo");
    private static final ProviderId PIDA = new ProviderId("of", "bar", true);
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:foo");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"of:bar");
    private static final String MFR = "whitebox";
    private static final String HW = "1.1.x";
    private static final String SW1 = "3.8.1";
    private static final String SW2 = "3.9.5";
    private static final String SN = "43311-12345";
    private static final ChassisId CID = new ChassisId();
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final PortNumber P2 = PortNumber.portNumber((long)2L);
    private static final PortNumber P3 = PortNumber.portNumber((long)3L);
    private static final SparseAnnotations A1 = DefaultAnnotations.builder().set("A1", "a1").set("B1", "b1").build();
    private static final SparseAnnotations A1_2 = DefaultAnnotations.builder().remove("A1").set("B3", "b3").build();
    private static final SparseAnnotations A2 = DefaultAnnotations.builder().set("A2", "a2").set("B2", "b2").build();
    private static final SparseAnnotations A2_2 = DefaultAnnotations.builder().remove("A2").set("B4", "b4").build();
    private static final NodeId NID1 = new NodeId("local");
    private static final ControllerNode ONOS1 = new DefaultControllerNode(NID1, IpAddress.valueOf((String)"127.0.0.1"));
    private static final NodeId NID2 = new NodeId("remote");
    private static final ControllerNode ONOS2 = new DefaultControllerNode(NID2, IpAddress.valueOf((String)"127.0.0.2"));
    private static final List<SparseAnnotations> NO_ANNOTATION = Collections.emptyList();
    private TestGossipDeviceStore testGossipDeviceStore;
    private GossipDeviceStore gossipDeviceStore;
    private DeviceStore deviceStore;
    private DeviceClockManager deviceClockManager;
    private DeviceClockService deviceClockService;
    private ClusterCommunicationService clusterCommunicator;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.deviceClockManager = new DeviceClockManager();
        this.deviceClockManager.activate();
        this.deviceClockService = this.deviceClockManager;
        this.deviceClockManager.setMastershipTerm(DID1, MastershipTerm.of((NodeId)NID1, (int)1));
        this.deviceClockManager.setMastershipTerm(DID2, MastershipTerm.of((NodeId)NID1, (int)2));
        this.clusterCommunicator = (ClusterCommunicationService)EasyMock.createNiceMock(ClusterCommunicationService.class);
        this.clusterCommunicator.addSubscriber((MessageSubject)EasyMock.anyObject(MessageSubject.class), (ClusterMessageHandler)EasyMock.anyObject(ClusterMessageHandler.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
        TestClusterService clusterService = new TestClusterService();
        this.testGossipDeviceStore = new TestGossipDeviceStore(this.deviceClockService, clusterService, this.clusterCommunicator);
        this.testGossipDeviceStore.mastershipService = new TestMastershipService();
        this.gossipDeviceStore = this.testGossipDeviceStore;
        this.gossipDeviceStore.activate();
        this.deviceStore = this.gossipDeviceStore;
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
    }

    @After
    public void tearDown() throws Exception {
        this.gossipDeviceStore.deactivate();
        this.deviceClockManager.deactivate();
    }

    private void putDevice(DeviceId deviceId, String swVersion, SparseAnnotations ... annotations) {
        DefaultDeviceDescription description = new DefaultDeviceDescription(deviceId.uri(), Device.Type.SWITCH, MFR, HW, swVersion, SN, CID, annotations);
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
        try {
            EasyMock.expect((Object)this.clusterCommunicator.broadcast((ClusterMessage)EasyMock.anyObject(ClusterMessage.class))).andReturn((Object)true).anyTimes();
        }
        catch (IOException e) {
            Assert.fail((String)"Should never reach here");
        }
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
        this.deviceStore.createOrUpdateDevice(PID, deviceId, (DeviceDescription)description);
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
    }

    private void putDeviceAncillary(DeviceId deviceId, String swVersion, SparseAnnotations ... annotations) {
        DefaultDeviceDescription description = new DefaultDeviceDescription(deviceId.uri(), Device.Type.SWITCH, MFR, HW, swVersion, SN, CID, annotations);
        this.deviceStore.createOrUpdateDevice(PIDA, deviceId, (DeviceDescription)description);
    }

    private static void assertDevice(DeviceId id, String swVersion, Device device) {
        Assert.assertNotNull((Object)device);
        Assert.assertEquals((Object)id, (Object)device.id());
        Assert.assertEquals((Object)MFR, (Object)device.manufacturer());
        Assert.assertEquals((Object)HW, (Object)device.hwVersion());
        Assert.assertEquals((Object)swVersion, (Object)device.swVersion());
        Assert.assertEquals((Object)SN, (Object)device.serialNumber());
    }

    private static void assertAnnotationsEquals(Annotations actual, SparseAnnotations ... annotations) {
        DefaultAnnotations expected = DefaultAnnotations.builder().build();
        for (SparseAnnotations a : annotations) {
            expected = DefaultAnnotations.union((SparseAnnotations)expected, (SparseAnnotations)a);
        }
        Assert.assertEquals((Object)expected.keys(), (Object)actual.keys());
        for (String key : expected.keys()) {
            Assert.assertEquals((Object)expected.value(key), (Object)actual.value(key));
        }
    }

    private static void assertDeviceDescriptionEquals(DeviceDescription expected, DeviceDescription actual) {
        if (expected == actual) {
            return;
        }
        Assert.assertEquals((Object)expected.deviceURI(), (Object)actual.deviceURI());
        Assert.assertEquals((Object)expected.hwVersion(), (Object)actual.hwVersion());
        Assert.assertEquals((Object)expected.manufacturer(), (Object)actual.manufacturer());
        Assert.assertEquals((Object)expected.serialNumber(), (Object)actual.serialNumber());
        Assert.assertEquals((Object)expected.swVersion(), (Object)actual.swVersion());
        GossipDeviceStoreTest.assertAnnotationsEquals((Annotations)actual.annotations(), expected.annotations());
    }

    private static void assertDeviceDescriptionEquals(DeviceDescription expected, List<SparseAnnotations> expectedAnnotations, DeviceDescription actual) {
        if (expected == actual) {
            return;
        }
        Assert.assertEquals((Object)expected.deviceURI(), (Object)actual.deviceURI());
        Assert.assertEquals((Object)expected.hwVersion(), (Object)actual.hwVersion());
        Assert.assertEquals((Object)expected.manufacturer(), (Object)actual.manufacturer());
        Assert.assertEquals((Object)expected.serialNumber(), (Object)actual.serialNumber());
        Assert.assertEquals((Object)expected.swVersion(), (Object)actual.swVersion());
        GossipDeviceStoreTest.assertAnnotationsEquals((Annotations)actual.annotations(), expectedAnnotations.toArray(new SparseAnnotations[0]));
    }

    @Test
    public final void testGetDeviceCount() {
        Assert.assertEquals((String)"initialy empty", (long)0L, (long)this.deviceStore.getDeviceCount());
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        this.putDevice(DID2, SW2, new SparseAnnotations[0]);
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        Assert.assertEquals((String)"expect 2 uniq devices", (long)2L, (long)this.deviceStore.getDeviceCount());
    }

    @Test
    public final void testGetDevices() {
        Assert.assertEquals((String)"initialy empty", (long)0L, (long)Iterables.size((Iterable)this.deviceStore.getDevices()));
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        this.putDevice(DID2, SW2, new SparseAnnotations[0]);
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        Assert.assertEquals((String)"expect 2 uniq devices", (long)2L, (long)Iterables.size((Iterable)this.deviceStore.getDevices()));
        HashMap<DeviceId, Device> devices = new HashMap<DeviceId, Device>();
        for (Device device : this.deviceStore.getDevices()) {
            devices.put(device.id(), device);
        }
        GossipDeviceStoreTest.assertDevice(DID1, SW1, (Device)devices.get(DID1));
        GossipDeviceStoreTest.assertDevice(DID2, SW2, (Device)devices.get(DID2));
    }

    @Test
    public final void testGetDevice() {
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        GossipDeviceStoreTest.assertDevice(DID1, SW1, this.deviceStore.getDevice(DID1));
        Assert.assertNull((String)"DID2 shouldn't be there", (Object)this.deviceStore.getDevice(DID2));
    }

    private void assertInternalDeviceEvent(NodeId sender, DeviceId deviceId, ProviderId providerId, DeviceDescription expectedDesc, Capture<ClusterMessage> actualMsg) {
        Assert.assertTrue((boolean)actualMsg.hasCaptured());
        Assert.assertEquals((Object)sender, (Object)((ClusterMessage)actualMsg.getValue()).sender());
        Assert.assertEquals((Object)GossipDeviceStoreMessageSubjects.DEVICE_UPDATE, (Object)((ClusterMessage)actualMsg.getValue()).subject());
        InternalDeviceEvent addEvent = (InternalDeviceEvent)this.testGossipDeviceStore.deserialize(((ClusterMessage)actualMsg.getValue()).payload());
        Assert.assertEquals((Object)deviceId, (Object)addEvent.deviceId());
        Assert.assertEquals((Object)providerId, (Object)addEvent.providerId());
        GossipDeviceStoreTest.assertDeviceDescriptionEquals(expectedDesc, (DeviceDescription)addEvent.deviceDescription().value());
    }

    private void assertInternalDeviceEvent(NodeId sender, DeviceId deviceId, ProviderId providerId, DeviceDescription expectedDesc, List<SparseAnnotations> expectedAnnotations, Capture<ClusterMessage> actualMsg) {
        Assert.assertTrue((boolean)actualMsg.hasCaptured());
        Assert.assertEquals((Object)sender, (Object)((ClusterMessage)actualMsg.getValue()).sender());
        Assert.assertEquals((Object)GossipDeviceStoreMessageSubjects.DEVICE_UPDATE, (Object)((ClusterMessage)actualMsg.getValue()).subject());
        InternalDeviceEvent addEvent = (InternalDeviceEvent)this.testGossipDeviceStore.deserialize(((ClusterMessage)actualMsg.getValue()).payload());
        Assert.assertEquals((Object)deviceId, (Object)addEvent.deviceId());
        Assert.assertEquals((Object)providerId, (Object)addEvent.providerId());
        GossipDeviceStoreTest.assertDeviceDescriptionEquals(expectedDesc, expectedAnnotations, (DeviceDescription)addEvent.deviceDescription().value());
    }

    @Test
    public final void testCreateOrUpdateDevice() throws IOException {
        DefaultDeviceDescription description = new DefaultDeviceDescription(DID1.uri(), Device.Type.SWITCH, MFR, HW, SW1, SN, CID, new SparseAnnotations[0]);
        Capture bcast = new Capture();
        this.resetCommunicatorExpectingSingleBroadcast((Capture<ClusterMessage>)bcast);
        DeviceEvent event = this.deviceStore.createOrUpdateDevice(PID, DID1, (DeviceDescription)description);
        Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_ADDED, (Object)event.type());
        GossipDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        this.assertInternalDeviceEvent(NID1, DID1, PID, (DeviceDescription)description, (Capture<ClusterMessage>)bcast);
        DefaultDeviceDescription description2 = new DefaultDeviceDescription(DID1.uri(), Device.Type.SWITCH, MFR, HW, SW2, SN, CID, new SparseAnnotations[0]);
        this.resetCommunicatorExpectingSingleBroadcast((Capture<ClusterMessage>)bcast);
        DeviceEvent event2 = this.deviceStore.createOrUpdateDevice(PID, DID1, (DeviceDescription)description2);
        Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_UPDATED, (Object)event2.type());
        GossipDeviceStoreTest.assertDevice(DID1, SW2, (Device)event2.subject());
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        this.assertInternalDeviceEvent(NID1, DID1, PID, (DeviceDescription)description2, (Capture<ClusterMessage>)bcast);
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
        Assert.assertNull((String)"No change expected", (Object)this.deviceStore.createOrUpdateDevice(PID, DID1, (DeviceDescription)description2));
    }

    @Test
    public final void testCreateOrUpdateDeviceAncillary() throws IOException {
        DefaultDeviceDescription description = new DefaultDeviceDescription(DID1.uri(), Device.Type.SWITCH, MFR, HW, SW1, SN, CID, new SparseAnnotations[]{A2});
        Capture bcast = new Capture();
        this.resetCommunicatorExpectingSingleBroadcast((Capture<ClusterMessage>)bcast);
        DeviceEvent event = this.deviceStore.createOrUpdateDevice(PIDA, DID1, (DeviceDescription)description);
        Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_ADDED, (Object)event.type());
        GossipDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
        Assert.assertEquals((Object)PIDA, (Object)((Device)event.subject()).providerId());
        GossipDeviceStoreTest.assertAnnotationsEquals(((Device)event.subject()).annotations(), A2);
        Assert.assertFalse((String)"Ancillary will not bring device up", (boolean)this.deviceStore.isAvailable(DID1));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        this.assertInternalDeviceEvent(NID1, DID1, PIDA, (DeviceDescription)description, (Capture<ClusterMessage>)bcast);
        DefaultDeviceDescription description2 = new DefaultDeviceDescription(DID1.uri(), Device.Type.SWITCH, MFR, HW, SW2, SN, CID, new SparseAnnotations[]{A1});
        this.resetCommunicatorExpectingSingleBroadcast((Capture<ClusterMessage>)bcast);
        DeviceEvent event2 = this.deviceStore.createOrUpdateDevice(PID, DID1, (DeviceDescription)description2);
        Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_UPDATED, (Object)event2.type());
        GossipDeviceStoreTest.assertDevice(DID1, SW2, (Device)event2.subject());
        Assert.assertEquals((Object)PID, (Object)((Device)event2.subject()).providerId());
        GossipDeviceStoreTest.assertAnnotationsEquals(((Device)event2.subject()).annotations(), A1, A2);
        Assert.assertTrue((boolean)this.deviceStore.isAvailable(DID1));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        this.assertInternalDeviceEvent(NID1, DID1, PID, (DeviceDescription)description2, (Capture<ClusterMessage>)bcast);
        this.resetCommunicatorExpectingNoBroadcast((Capture<ClusterMessage>)bcast);
        Assert.assertNull((String)"No change expected", (Object)this.deviceStore.createOrUpdateDevice(PID, DID1, (DeviceDescription)description2));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        Assert.assertFalse((String)"no broadcast expected", (boolean)bcast.hasCaptured());
        this.resetCommunicatorExpectingNoBroadcast((Capture<ClusterMessage>)bcast);
        Assert.assertNull((String)"No change expected", (Object)this.deviceStore.createOrUpdateDevice(PIDA, DID1, (DeviceDescription)description));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        Assert.assertFalse((String)"no broadcast expected", (boolean)bcast.hasCaptured());
        DefaultDeviceDescription description3 = new DefaultDeviceDescription(DID1.uri(), Device.Type.SWITCH, MFR, HW, SW1, SN, CID, new SparseAnnotations[]{A2_2});
        this.resetCommunicatorExpectingSingleBroadcast((Capture<ClusterMessage>)bcast);
        DeviceEvent event3 = this.deviceStore.createOrUpdateDevice(PIDA, DID1, (DeviceDescription)description3);
        Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_UPDATED, (Object)event3.type());
        GossipDeviceStoreTest.assertDevice(DID1, SW2, (Device)event3.subject());
        Assert.assertEquals((Object)PID, (Object)((Device)event3.subject()).providerId());
        GossipDeviceStoreTest.assertAnnotationsEquals(((Device)event3.subject()).annotations(), A1, A2, A2_2);
        Assert.assertTrue((boolean)this.deviceStore.isAvailable(DID1));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        this.assertInternalDeviceEvent(NID1, DID1, PIDA, (DeviceDescription)description3, Arrays.asList(DefaultAnnotations.union((SparseAnnotations)A2, (SparseAnnotations)A2_2)), (Capture<ClusterMessage>)bcast);
    }

    @Test
    public final void testMarkOffline() {
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        Assert.assertTrue((boolean)this.deviceStore.isAvailable(DID1));
        Capture bcast = new Capture();
        this.resetCommunicatorExpectingSingleBroadcast((Capture<ClusterMessage>)bcast);
        DeviceEvent event = this.deviceStore.markOffline(DID1);
        Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED, (Object)event.type());
        GossipDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
        Assert.assertFalse((boolean)this.deviceStore.isAvailable(DID1));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        Assert.assertTrue((boolean)bcast.hasCaptured());
        this.resetCommunicatorExpectingNoBroadcast((Capture<ClusterMessage>)bcast);
        DeviceEvent event2 = this.deviceStore.markOffline(DID1);
        Assert.assertNull((String)"No change, no event", (Object)event2);
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        Assert.assertFalse((boolean)bcast.hasCaptured());
    }

    @Test
    public final void testUpdatePorts() {
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        List<PortDescription> pds = Arrays.asList(new DefaultPortDescription(P1, true, new SparseAnnotations[0]), new DefaultPortDescription(P2, true, new SparseAnnotations[0]));
        Capture bcast = new Capture();
        this.resetCommunicatorExpectingSingleBroadcast((Capture<ClusterMessage>)bcast);
        List events = this.deviceStore.updatePorts(PID, DID1, pds);
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        Assert.assertTrue((boolean)bcast.hasCaptured());
        HashSet expectedPorts = Sets.newHashSet((Object[])new PortNumber[]{P1, P2});
        for (Object event : events) {
            Assert.assertEquals((Object)DeviceEvent.Type.PORT_ADDED, (Object)event.type());
            GossipDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
            Assert.assertTrue((String)"PortNumber is one of expected", (boolean)expectedPorts.remove(event.port().number()));
            Assert.assertTrue((String)"Port is enabled", (boolean)event.port().isEnabled());
        }
        Assert.assertTrue((String)"Event for all expectedport appeared", (boolean)expectedPorts.isEmpty());
        List<PortDescription> pds2 = Arrays.asList(new DefaultPortDescription(P1, false, new SparseAnnotations[0]), new DefaultPortDescription(P2, true, new SparseAnnotations[0]), new DefaultPortDescription(P3, true, new SparseAnnotations[0]));
        this.resetCommunicatorExpectingSingleBroadcast((Capture<ClusterMessage>)bcast);
        events = this.deviceStore.updatePorts(PID, DID1, pds2);
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        Assert.assertTrue((boolean)bcast.hasCaptured());
        Assert.assertFalse((String)"event should be triggered", (boolean)events.isEmpty());
        for (DeviceEvent event : events) {
            PortNumber num = event.port().number();
            if (P1.equals((Object)num)) {
                Assert.assertEquals((Object)DeviceEvent.Type.PORT_UPDATED, (Object)event.type());
                GossipDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
                Assert.assertFalse((String)"Port is disabled", (boolean)event.port().isEnabled());
                continue;
            }
            if (P2.equals((Object)num)) {
                Assert.fail((String)"P2 event not expected.");
                continue;
            }
            if (P3.equals((Object)num)) {
                Assert.assertEquals((Object)DeviceEvent.Type.PORT_ADDED, (Object)event.type());
                GossipDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
                Assert.assertTrue((String)"Port is enabled", (boolean)event.port().isEnabled());
                continue;
            }
            Assert.fail((String)("Unknown port number encountered: " + num));
        }
        List<PortDescription> pds3 = Arrays.asList(new DefaultPortDescription(P1, false, new SparseAnnotations[0]), new DefaultPortDescription(P2, true, new SparseAnnotations[0]));
        this.resetCommunicatorExpectingSingleBroadcast((Capture<ClusterMessage>)bcast);
        events = this.deviceStore.updatePorts(PID, DID1, pds3);
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        Assert.assertTrue((boolean)bcast.hasCaptured());
        Assert.assertFalse((String)"event should be triggered", (boolean)events.isEmpty());
        for (DeviceEvent event : events) {
            PortNumber num = event.port().number();
            if (P1.equals((Object)num)) {
                Assert.fail((String)"P1 event not expected.");
                continue;
            }
            if (P2.equals((Object)num)) {
                Assert.fail((String)"P2 event not expected.");
                continue;
            }
            if (P3.equals((Object)num)) {
                Assert.assertEquals((Object)DeviceEvent.Type.PORT_REMOVED, (Object)event.type());
                GossipDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
                Assert.assertTrue((String)"Port was enabled", (boolean)event.port().isEnabled());
                continue;
            }
            Assert.fail((String)("Unknown port number encountered: " + num));
        }
    }

    @Test
    public final void testUpdatePortStatus() {
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        List<PortDescription> pds = Arrays.asList(new DefaultPortDescription(P1, true, new SparseAnnotations[0]));
        this.deviceStore.updatePorts(PID, DID1, pds);
        Capture bcast = new Capture();
        this.resetCommunicatorExpectingSingleBroadcast((Capture<ClusterMessage>)bcast);
        DefaultPortDescription desc = new DefaultPortDescription(P1, false, new SparseAnnotations[0]);
        DeviceEvent event = this.deviceStore.updatePortStatus(PID, DID1, (PortDescription)desc);
        Assert.assertEquals((Object)DeviceEvent.Type.PORT_UPDATED, (Object)event.type());
        GossipDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
        Assert.assertEquals((Object)P1, (Object)event.port().number());
        Assert.assertFalse((String)"Port is disabled", (boolean)event.port().isEnabled());
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        this.assertInternalPortStatusEvent(NID1, DID1, PID, desc, NO_ANNOTATION, (Capture<ClusterMessage>)bcast);
        Assert.assertTrue((boolean)bcast.hasCaptured());
    }

    @Test
    public final void testUpdatePortStatusAncillary() throws IOException {
        this.putDeviceAncillary(DID1, SW1, new SparseAnnotations[0]);
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        List<PortDescription> pds = Arrays.asList(new DefaultPortDescription(P1, true, new SparseAnnotations[]{A1}));
        this.deviceStore.updatePorts(PID, DID1, pds);
        Capture bcast = new Capture();
        this.resetCommunicatorExpectingSingleBroadcast((Capture<ClusterMessage>)bcast);
        DefaultPortDescription desc1 = new DefaultPortDescription(P1, false, new SparseAnnotations[]{A1_2});
        DeviceEvent event = this.deviceStore.updatePortStatus(PID, DID1, (PortDescription)desc1);
        Assert.assertEquals((Object)DeviceEvent.Type.PORT_UPDATED, (Object)event.type());
        GossipDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
        Assert.assertEquals((Object)P1, (Object)event.port().number());
        GossipDeviceStoreTest.assertAnnotationsEquals(event.port().annotations(), A1, A1_2);
        Assert.assertFalse((String)"Port is disabled", (boolean)event.port().isEnabled());
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        this.assertInternalPortStatusEvent(NID1, DID1, PID, desc1, Arrays.asList(A1, A1_2), (Capture<ClusterMessage>)bcast);
        Assert.assertTrue((boolean)bcast.hasCaptured());
        this.resetCommunicatorExpectingNoBroadcast((Capture<ClusterMessage>)bcast);
        DefaultPortDescription desc2 = new DefaultPortDescription(P1, true, new SparseAnnotations[0]);
        DeviceEvent event2 = this.deviceStore.updatePortStatus(PIDA, DID1, (PortDescription)desc2);
        Assert.assertNull((String)"Ancillary is ignored if primary exists", (Object)event2);
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        Assert.assertFalse((boolean)bcast.hasCaptured());
        this.resetCommunicatorExpectingSingleBroadcast((Capture<ClusterMessage>)bcast);
        DefaultPortDescription desc3 = new DefaultPortDescription(P1, true, new SparseAnnotations[]{A2});
        DeviceEvent event3 = this.deviceStore.updatePortStatus(PIDA, DID1, (PortDescription)desc3);
        Assert.assertEquals((Object)DeviceEvent.Type.PORT_UPDATED, (Object)event3.type());
        GossipDeviceStoreTest.assertDevice(DID1, SW1, (Device)event3.subject());
        Assert.assertEquals((Object)P1, (Object)event3.port().number());
        GossipDeviceStoreTest.assertAnnotationsEquals(event3.port().annotations(), A1, A1_2, A2);
        Assert.assertFalse((String)"Port is disabled", (boolean)event3.port().isEnabled());
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        this.assertInternalPortStatusEvent(NID1, DID1, PIDA, desc3, Arrays.asList(A2), (Capture<ClusterMessage>)bcast);
        Assert.assertTrue((boolean)bcast.hasCaptured());
        this.resetCommunicatorExpectingSingleBroadcast((Capture<ClusterMessage>)bcast);
        DefaultPortDescription desc4 = new DefaultPortDescription(P2, true, new SparseAnnotations[0]);
        DeviceEvent event4 = this.deviceStore.updatePortStatus(PIDA, DID1, (PortDescription)desc4);
        Assert.assertEquals((Object)DeviceEvent.Type.PORT_ADDED, (Object)event4.type());
        GossipDeviceStoreTest.assertDevice(DID1, SW1, (Device)event4.subject());
        Assert.assertEquals((Object)P2, (Object)event4.port().number());
        GossipDeviceStoreTest.assertAnnotationsEquals(event4.port().annotations(), new SparseAnnotations[0]);
        Assert.assertFalse((String)"Port is disabled if not given from primary provider", (boolean)event4.port().isEnabled());
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        this.assertInternalPortStatusEvent(NID1, DID1, PIDA, desc4, NO_ANNOTATION, (Capture<ClusterMessage>)bcast);
        Assert.assertTrue((boolean)bcast.hasCaptured());
    }

    private void assertInternalPortStatusEvent(NodeId sender, DeviceId did, ProviderId pid, DefaultPortDescription expectedDesc, List<SparseAnnotations> expectedAnnotations, Capture<ClusterMessage> actualMsg) {
        Assert.assertTrue((boolean)actualMsg.hasCaptured());
        Assert.assertEquals((Object)sender, (Object)((ClusterMessage)actualMsg.getValue()).sender());
        Assert.assertEquals((Object)GossipDeviceStoreMessageSubjects.PORT_STATUS_UPDATE, (Object)((ClusterMessage)actualMsg.getValue()).subject());
        InternalPortStatusEvent addEvent = (InternalPortStatusEvent)this.testGossipDeviceStore.deserialize(((ClusterMessage)actualMsg.getValue()).payload());
        Assert.assertEquals((Object)did, (Object)addEvent.deviceId());
        Assert.assertEquals((Object)pid, (Object)addEvent.providerId());
        this.assertPortDescriptionEquals((PortDescription)expectedDesc, expectedAnnotations, (PortDescription)addEvent.portDescription().value());
    }

    private void assertPortDescriptionEquals(PortDescription expectedDesc, List<SparseAnnotations> expectedAnnotations, PortDescription actual) {
        Assert.assertEquals((Object)expectedDesc.portNumber(), (Object)actual.portNumber());
        Assert.assertEquals((Object)expectedDesc.isEnabled(), (Object)actual.isEnabled());
        GossipDeviceStoreTest.assertAnnotationsEquals((Annotations)actual.annotations(), expectedAnnotations.toArray(new SparseAnnotations[0]));
    }

    private void resetCommunicatorExpectingNoBroadcast(Capture<ClusterMessage> bcast) {
        bcast.reset();
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
    }

    private void resetCommunicatorExpectingSingleBroadcast(Capture<ClusterMessage> bcast) {
        bcast.reset();
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
        try {
            EasyMock.expect((Object)this.clusterCommunicator.broadcast((ClusterMessage)EasyMock.capture(bcast))).andReturn((Object)true).once();
        }
        catch (IOException e) {
            Assert.fail((String)"Should never reach here");
        }
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
    }

    @Test
    public final void testGetPorts() {
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        this.putDevice(DID2, SW1, new SparseAnnotations[0]);
        List<PortDescription> pds = Arrays.asList(new DefaultPortDescription(P1, true, new SparseAnnotations[0]), new DefaultPortDescription(P2, true, new SparseAnnotations[0]));
        this.deviceStore.updatePorts(PID, DID1, pds);
        HashSet expectedPorts = Sets.newHashSet((Object[])new PortNumber[]{P1, P2});
        List ports = this.deviceStore.getPorts(DID1);
        for (Port port : ports) {
            Assert.assertTrue((String)"Port is enabled", (boolean)port.isEnabled());
            Assert.assertTrue((String)"PortNumber is one of expected", (boolean)expectedPorts.remove(port.number()));
        }
        Assert.assertTrue((String)"Event for all expectedport appeared", (boolean)expectedPorts.isEmpty());
        Assert.assertTrue((String)"DID2 has no ports", (boolean)this.deviceStore.getPorts(DID2).isEmpty());
    }

    @Test
    public final void testGetPort() {
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        this.putDevice(DID2, SW1, new SparseAnnotations[0]);
        List<PortDescription> pds = Arrays.asList(new DefaultPortDescription(P1, true, new SparseAnnotations[0]), new DefaultPortDescription(P2, false, new SparseAnnotations[0]));
        this.deviceStore.updatePorts(PID, DID1, pds);
        Port port1 = this.deviceStore.getPort(DID1, P1);
        Assert.assertEquals((Object)P1, (Object)port1.number());
        Assert.assertTrue((String)"Port is enabled", (boolean)port1.isEnabled());
        Port port2 = this.deviceStore.getPort(DID1, P2);
        Assert.assertEquals((Object)P2, (Object)port2.number());
        Assert.assertFalse((String)"Port is disabled", (boolean)port2.isEnabled());
        Port port3 = this.deviceStore.getPort(DID1, P3);
        Assert.assertNull((String)"P3 not expected", (Object)port3);
    }

    @Test
    public final void testRemoveDevice() {
        this.putDevice(DID1, SW1, A1);
        List<PortDescription> pds = Arrays.asList(new DefaultPortDescription(P1, true, new SparseAnnotations[]{A2}));
        this.deviceStore.updatePorts(PID, DID1, pds);
        this.putDevice(DID2, SW1, new SparseAnnotations[0]);
        Assert.assertEquals((long)2L, (long)this.deviceStore.getDeviceCount());
        Assert.assertEquals((long)1L, (long)this.deviceStore.getPorts(DID1).size());
        GossipDeviceStoreTest.assertAnnotationsEquals(this.deviceStore.getDevice(DID1).annotations(), A1);
        GossipDeviceStoreTest.assertAnnotationsEquals(this.deviceStore.getPort(DID1, P1).annotations(), A2);
        Capture bcast = new Capture();
        this.resetCommunicatorExpectingSingleBroadcast((Capture<ClusterMessage>)bcast);
        DeviceEvent event = this.deviceStore.removeDevice(DID1);
        Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_REMOVED, (Object)event.type());
        GossipDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
        Assert.assertEquals((long)1L, (long)this.deviceStore.getDeviceCount());
        Assert.assertEquals((long)0L, (long)this.deviceStore.getPorts(DID1).size());
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        Assert.assertTrue((boolean)bcast.hasCaptured());
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        List<PortDescription> pds2 = Arrays.asList(new DefaultPortDescription(P1, true, new SparseAnnotations[0]));
        this.deviceStore.updatePorts(PID, DID1, pds2);
        Assert.assertEquals((long)2L, (long)this.deviceStore.getDeviceCount());
        Assert.assertEquals((long)1L, (long)this.deviceStore.getPorts(DID1).size());
        GossipDeviceStoreTest.assertAnnotationsEquals(this.deviceStore.getDevice(DID1).annotations(), new SparseAnnotations[0]);
        GossipDeviceStoreTest.assertAnnotationsEquals(this.deviceStore.getPort(DID1, P1).annotations(), new SparseAnnotations[0]);
    }

    @Ignore(value="Ignore until Delegate spec. is clear.")
    @Test
    public final void testEvents() throws InterruptedException {
        final CountDownLatch addLatch = new CountDownLatch(1);
        DeviceStoreDelegate checkAdd = new DeviceStoreDelegate(){

            public void notify(DeviceEvent event) {
                Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_ADDED, (Object)event.type());
                GossipDeviceStoreTest.assertDevice(DID1, GossipDeviceStoreTest.SW1, (Device)event.subject());
                addLatch.countDown();
            }
        };
        final CountDownLatch updateLatch = new CountDownLatch(1);
        DeviceStoreDelegate checkUpdate = new DeviceStoreDelegate(){

            public void notify(DeviceEvent event) {
                Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_UPDATED, (Object)event.type());
                GossipDeviceStoreTest.assertDevice(DID1, GossipDeviceStoreTest.SW2, (Device)event.subject());
                updateLatch.countDown();
            }
        };
        final CountDownLatch removeLatch = new CountDownLatch(1);
        DeviceStoreDelegate checkRemove = new DeviceStoreDelegate(){

            public void notify(DeviceEvent event) {
                Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_REMOVED, (Object)event.type());
                GossipDeviceStoreTest.assertDevice(DID1, GossipDeviceStoreTest.SW2, (Device)event.subject());
                removeLatch.countDown();
            }
        };
        DefaultDeviceDescription description = new DefaultDeviceDescription(DID1.uri(), Device.Type.SWITCH, MFR, HW, SW1, SN, CID, new SparseAnnotations[0]);
        this.deviceStore.setDelegate((StoreDelegate)checkAdd);
        this.deviceStore.createOrUpdateDevice(PID, DID1, (DeviceDescription)description);
        Assert.assertTrue((String)"Add event fired", (boolean)addLatch.await(1L, TimeUnit.SECONDS));
        DefaultDeviceDescription description2 = new DefaultDeviceDescription(DID1.uri(), Device.Type.SWITCH, MFR, HW, SW2, SN, CID, new SparseAnnotations[0]);
        this.deviceStore.unsetDelegate((StoreDelegate)checkAdd);
        this.deviceStore.setDelegate((StoreDelegate)checkUpdate);
        this.deviceStore.createOrUpdateDevice(PID, DID1, (DeviceDescription)description2);
        Assert.assertTrue((String)"Update event fired", (boolean)updateLatch.await(1L, TimeUnit.SECONDS));
        this.deviceStore.unsetDelegate((StoreDelegate)checkUpdate);
        this.deviceStore.setDelegate((StoreDelegate)checkRemove);
        this.deviceStore.removeDevice(DID1);
        Assert.assertTrue((String)"Remove event fired", (boolean)removeLatch.await(1L, TimeUnit.SECONDS));
    }

    private static final class TestClusterService
    extends StaticClusterService {
        public TestClusterService() {
            this.localNode = ONOS1;
            this.nodes.put(NID1, ONOS1);
            this.nodeStates.put(NID1, ControllerNode.State.ACTIVE);
            this.nodes.put(NID2, ONOS2);
            this.nodeStates.put(NID2, ControllerNode.State.ACTIVE);
        }
    }

    private static final class TestGossipDeviceStore
    extends GossipDeviceStore {
        public TestGossipDeviceStore(DeviceClockService deviceClockService, ClusterService clusterService, ClusterCommunicationService clusterCommunicator) {
            this.deviceClockService = deviceClockService;
            this.clusterService = clusterService;
            this.clusterCommunicator = clusterCommunicator;
        }

        public <T> T deserialize(byte[] bytes) {
            return (T)SERIALIZER.decode(bytes);
        }
    }

    private final class TestMastershipService
    extends MastershipServiceAdapter {
        private TestMastershipService() {
        }

        public NodeId getMasterFor(DeviceId deviceId) {
            return NID1;
        }
    }
}

