/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.flow.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.event.AbstractListenerRegistry;
import org.onosproject.event.DefaultEventSinkRegistry;
import org.onosproject.event.Event;
import org.onosproject.event.EventDeliveryService;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.mastership.MastershipServiceAdapter;
import org.onosproject.net.DeviceId;
import org.onosproject.store.flow.ReplicaInfo;
import org.onosproject.store.flow.ReplicaInfoEvent;
import org.onosproject.store.flow.ReplicaInfoEventListener;
import org.onosproject.store.flow.ReplicaInfoService;
import org.onosproject.store.flow.impl.ReplicaInfoManager;

public class ReplicaInfoManagerTest {
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:1");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"of:2");
    private static final NodeId NID1 = new NodeId("foo");
    private ReplicaInfoManager mgr;
    private ReplicaInfoService service;
    private AbstractListenerRegistry<MastershipEvent, MastershipListener> mastershipListenerRegistry;
    private TestEventDispatcher eventDispatcher;

    @Before
    public void setUp() throws Exception {
        this.mastershipListenerRegistry = new AbstractListenerRegistry();
        this.mgr = new ReplicaInfoManager();
        this.service = this.mgr;
        this.eventDispatcher = new TestEventDispatcher();
        this.mgr.eventDispatcher = this.eventDispatcher;
        this.mgr.mastershipService = new TestMastershipService();
        this.mgr.eventDispatcher.addSink(MastershipEvent.class, this.mastershipListenerRegistry);
        this.mgr.activate();
    }

    @After
    public void tearDown() throws Exception {
        this.mgr.deactivate();
    }

    @Test
    public void testGetReplicaInfoFor() {
        ReplicaInfo info1 = this.service.getReplicaInfoFor(DID1);
        Assert.assertEquals((Object)Optional.of((Object)NID1), (Object)info1.master());
        Assert.assertEquals(Collections.emptyList(), (Object)info1.backups());
        ReplicaInfo info2 = this.service.getReplicaInfoFor(DID2);
        Assert.assertEquals((String)"There's no master", (Object)Optional.absent(), (Object)info2.master());
        Assert.assertEquals(Collections.emptyList(), (Object)info2.backups());
    }

    @Test
    public void testReplicaInfoEvent() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.service.addListener((ReplicaInfoEventListener)new MasterNodeCheck(latch, DID1, NID1));
        this.eventDispatcher.post((Event)new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, DID1, new RoleInfo(NID1, new LinkedList())));
        Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
    }

    private static class TestEventDispatcher
    extends DefaultEventSinkRegistry
    implements EventDeliveryService {
        private TestEventDispatcher() {
        }

        public void post(Event event) {
            EventSink sink = this.getSink(event.getClass());
            Preconditions.checkState((sink != null ? 1 : 0) != 0, (String)"No sink for event %s", (Object[])new Object[]{event});
            sink.process(event);
        }
    }

    private final class TestMastershipService
    extends MastershipServiceAdapter
    implements MastershipService {
        private Map<DeviceId, NodeId> masters = Maps.newHashMap();

        TestMastershipService() {
            this.masters.put(DID1, NID1);
        }

        public NodeId getMasterFor(DeviceId deviceId) {
            return this.masters.get(deviceId);
        }

        public void addListener(MastershipListener listener) {
            ReplicaInfoManagerTest.this.mastershipListenerRegistry.addListener((EventListener)listener);
        }

        public void removeListener(MastershipListener listener) {
            ReplicaInfoManagerTest.this.mastershipListenerRegistry.removeListener((EventListener)listener);
        }
    }

    private final class MasterNodeCheck
    implements ReplicaInfoEventListener {
        private final CountDownLatch latch;
        private Optional<NodeId> expectedMaster;
        private DeviceId expectedDevice;

        MasterNodeCheck(CountDownLatch latch, DeviceId did, NodeId nid) {
            this.latch = latch;
            this.expectedMaster = Optional.fromNullable((Object)nid);
            this.expectedDevice = did;
        }

        public void event(ReplicaInfoEvent event) {
            Assert.assertEquals((Object)this.expectedDevice, (Object)event.subject());
            Assert.assertEquals(this.expectedMaster, (Object)event.replicaInfo().master());
            Assert.assertEquals(Collections.emptyList(), (Object)event.replicaInfo().backups());
            this.latch.countDown();
        }
    }
}

