/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import java.util.HashSet;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.resource.Bandwidth;
import org.onosproject.net.resource.BandwidthResourceAllocation;
import org.onosproject.net.resource.LambdaResourceAllocation;
import org.onosproject.net.resource.LinkResourceStore;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceType;
import org.onosproject.store.hz.StoreService;
import org.onosproject.store.hz.TestStoreManager;
import org.onosproject.store.resource.impl.HazelcastLinkResourceStore;

public class HazelcastLinkResourceStoreTest {
    private LinkResourceStore store;
    private HazelcastLinkResourceStore storeImpl;
    private Link link1;
    private Link link2;
    private Link link3;
    private TestStoreManager storeMgr;

    private Link newLink(String dev1, int port1, String dev2, int port2) {
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("optical.waves", "80").set("bandwidth", "1000000").build();
        return new DefaultLink(new ProviderId("of", "foo"), new ConnectPoint((ElementId)DeviceId.deviceId((String)dev1), PortNumber.portNumber((long)port1)), new ConnectPoint((ElementId)DeviceId.deviceId((String)dev2), PortNumber.portNumber((long)port2)), Link.Type.DIRECT, new Annotations[]{annotations});
    }

    @Before
    public void setUp() throws Exception {
        Config config = TestStoreManager.getTestConfig();
        this.storeMgr = new TestStoreManager(Hazelcast.newHazelcastInstance((Config)config));
        this.storeMgr.activate();
        this.storeImpl = new TestHazelcastLinkResourceStore((StoreService)this.storeMgr);
        this.storeImpl.activate();
        this.store = this.storeImpl;
        this.link1 = this.newLink("of:1", 1, "of:2", 2);
        this.link2 = this.newLink("of:2", 1, "of:3", 2);
        this.link3 = this.newLink("of:3", 1, "of:4", 2);
    }

    @After
    public void tearDown() throws Exception {
        this.storeImpl.deactivate();
        this.storeMgr.deactivate();
    }

    @Test
    public void testConstructorAndActivate() {
        Iterable allAllocations = this.store.getAllocations();
        Assert.assertNotNull((Object)allAllocations);
        Assert.assertFalse((boolean)allAllocations.iterator().hasNext());
        Iterable linkAllocations = this.store.getAllocations(this.link1);
        Assert.assertNotNull((Object)linkAllocations);
        Assert.assertFalse((boolean)linkAllocations.iterator().hasNext());
        Set res = this.store.getFreeResources(this.link2);
        Assert.assertNotNull((Object)res);
    }

    private BandwidthResourceAllocation getBandwidthObj(Set<ResourceAllocation> resources) {
        for (ResourceAllocation res : resources) {
            if (res.type() != ResourceType.BANDWIDTH) continue;
            return (BandwidthResourceAllocation)res;
        }
        return null;
    }

    private Set<LambdaResourceAllocation> getLambdaObjs(Set<ResourceAllocation> resources) {
        HashSet<LambdaResourceAllocation> lambdaResources = new HashSet<LambdaResourceAllocation>();
        for (ResourceAllocation res : resources) {
            if (res.type() != ResourceType.LAMBDA) continue;
            lambdaResources.add((LambdaResourceAllocation)res);
        }
        return lambdaResources;
    }

    @Test
    public void testInitialBandwidth() {
        Set freeRes = this.store.getFreeResources(this.link1);
        Assert.assertNotNull((Object)freeRes);
        BandwidthResourceAllocation alloc = this.getBandwidthObj(freeRes);
        Assert.assertNotNull((Object)alloc);
        Assert.assertEquals((Object)Bandwidth.valueOf((double)1000000.0), (Object)alloc.bandwidth());
    }

    @Test
    public void testInitialLambdas() {
        Set freeRes = this.store.getFreeResources(this.link3);
        Assert.assertNotNull((Object)freeRes);
        Set<LambdaResourceAllocation> res = this.getLambdaObjs(freeRes);
        Assert.assertNotNull(res);
        Assert.assertEquals((long)80L, (long)res.size());
    }

    public static final class TestHazelcastLinkResourceStore
    extends HazelcastLinkResourceStore {
        public TestHazelcastLinkResourceStore(StoreService storeMgr) {
            this.storeService = storeMgr;
        }
    }
}

