/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service.impl;

import com.google.common.testing.EqualsTester;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import net.kuujo.copycat.internal.log.OperationEntry;
import net.kuujo.copycat.log.Entry;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.store.serializers.StoreSerializer;
import org.onosproject.store.service.impl.ClusterMessagingProtocol;
import org.onosproject.store.service.impl.MapDBLog;

public class MapDBLogTest {
    private static final StoreSerializer SERIALIZER = ClusterMessagingProtocol.DB_SERIALIZER;
    private static final Entry TEST_ENTRY1 = new OperationEntry(1L, "test1", new Object[0]);
    private static final Entry TEST_ENTRY2 = new OperationEntry(2L, "test12", new Object[0]);
    private static final Entry TEST_ENTRY3 = new OperationEntry(3L, "test123", new Object[0]);
    private static final Entry TEST_ENTRY4 = new OperationEntry(4L, "test1234", new Object[0]);
    private static final Entry TEST_SNAPSHOT_ENTRY = new OperationEntry(5L, "snapshot", new Object[0]);
    private static final long TEST_ENTRY1_SIZE = SERIALIZER.encode((Object)TEST_ENTRY1).length;
    private static final long TEST_ENTRY2_SIZE = SERIALIZER.encode((Object)TEST_ENTRY2).length;
    private static final long TEST_ENTRY3_SIZE = SERIALIZER.encode((Object)TEST_ENTRY3).length;
    private static final long TEST_ENTRY4_SIZE = SERIALIZER.encode((Object)TEST_ENTRY4).length;
    private static final long TEST_SNAPSHOT_ENTRY_SIZE = SERIALIZER.encode((Object)TEST_SNAPSHOT_ENTRY).length;
    private String dbFileName;

    @Before
    public void setUp() throws Exception {
        File logFile = File.createTempFile("mapdbTest", null);
        this.dbFileName = logFile.getAbsolutePath();
    }

    @After
    public void tearDown() throws Exception {
        Files.deleteIfExists(new File(this.dbFileName).toPath());
        Files.deleteIfExists(new File(this.dbFileName + ".t").toPath());
        Files.deleteIfExists(new File(this.dbFileName + ".p").toPath());
    }

    @Test(expected=IllegalStateException.class)
    public void testAssertOpen() {
        MapDBLog log = new MapDBLog(this.dbFileName, SERIALIZER);
        log.size();
    }

    @Test
    public void testAppendEntry() throws IOException {
        MapDBLog log = new MapDBLog(this.dbFileName, SERIALIZER);
        log.open();
        log.appendEntry(TEST_ENTRY1);
        OperationEntry first = (OperationEntry)log.firstEntry();
        OperationEntry last = (OperationEntry)log.lastEntry();
        new EqualsTester().addEqualityGroup(new Object[]{first, last, TEST_ENTRY1}).testEquals();
        Assert.assertEquals((long)TEST_ENTRY1_SIZE, (long)log.size());
        Assert.assertEquals((long)1L, (long)log.firstIndex());
        Assert.assertEquals((long)1L, (long)log.lastIndex());
    }

    @Test
    public void testAppendEntries() throws IOException {
        MapDBLog log = new MapDBLog(this.dbFileName, SERIALIZER);
        log.open();
        log.appendEntries(new Entry[]{TEST_ENTRY1, TEST_ENTRY2, TEST_ENTRY3});
        OperationEntry first = (OperationEntry)log.firstEntry();
        OperationEntry last = (OperationEntry)log.lastEntry();
        new EqualsTester().addEqualityGroup(new Object[]{first, TEST_ENTRY1}).addEqualityGroup(new Object[]{last, TEST_ENTRY3}).testEquals();
        Assert.assertEquals((float)(TEST_ENTRY1_SIZE + TEST_ENTRY2_SIZE), (float)TEST_ENTRY3_SIZE, (float)log.size());
        Assert.assertEquals((long)1L, (long)log.firstIndex());
        Assert.assertEquals((long)3L, (long)log.lastIndex());
        Assert.assertTrue((boolean)log.containsEntry(1L));
        Assert.assertTrue((boolean)log.containsEntry(2L));
    }

    @Test
    public void testDelete() throws IOException {
        MapDBLog log = new MapDBLog(this.dbFileName, SERIALIZER);
        log.open();
        log.appendEntries(new Entry[]{TEST_ENTRY1, TEST_ENTRY2});
        log.delete();
        Assert.assertEquals((long)0L, (long)log.size());
        Assert.assertTrue((boolean)log.isEmpty());
        Assert.assertEquals((long)0L, (long)log.firstIndex());
        Assert.assertNull((Object)log.firstEntry());
        Assert.assertEquals((long)0L, (long)log.lastIndex());
        Assert.assertNull((Object)log.lastEntry());
    }

    @Test
    public void testGetEntries() throws IOException {
        MapDBLog log = new MapDBLog(this.dbFileName, SERIALIZER);
        log.open();
        log.appendEntries(new Entry[]{TEST_ENTRY1, TEST_ENTRY2, TEST_ENTRY3, TEST_ENTRY4});
        Assert.assertEquals((long)(TEST_ENTRY1_SIZE + TEST_ENTRY2_SIZE + TEST_ENTRY3_SIZE + TEST_ENTRY4_SIZE), (long)log.size());
        List entries = log.getEntries(2L, 3L);
        new EqualsTester().addEqualityGroup(new Object[]{log.getEntry(4L), TEST_ENTRY4}).addEqualityGroup(new Object[]{entries.get(0), TEST_ENTRY2}).addEqualityGroup(new Object[]{entries.get(1), TEST_ENTRY3}).testEquals();
    }

    @Test
    public void testRemoveAfter() throws IOException {
        MapDBLog log = new MapDBLog(this.dbFileName, SERIALIZER);
        log.open();
        log.appendEntries(new Entry[]{TEST_ENTRY1, TEST_ENTRY2, TEST_ENTRY3, TEST_ENTRY4});
        log.removeAfter(1L);
        Assert.assertEquals((long)TEST_ENTRY1_SIZE, (long)log.size());
        new EqualsTester().addEqualityGroup(new Object[]{log.firstEntry(), log.lastEntry(), TEST_ENTRY1}).testEquals();
    }

    @Test
    public void testAddAfterRemove() throws IOException {
        MapDBLog log = new MapDBLog(this.dbFileName, SERIALIZER);
        log.open();
        log.appendEntries(new Entry[]{TEST_ENTRY1, TEST_ENTRY2, TEST_ENTRY3, TEST_ENTRY4});
        log.removeAfter(1L);
        log.appendEntry(TEST_ENTRY4);
        Assert.assertEquals((long)(TEST_ENTRY1_SIZE + TEST_ENTRY4_SIZE), (long)log.size());
        new EqualsTester().addEqualityGroup(new Object[]{log.firstEntry(), TEST_ENTRY1}).addEqualityGroup(new Object[]{log.lastEntry(), TEST_ENTRY4}).addEqualityGroup(new Object[]{log.size(), TEST_ENTRY1_SIZE + TEST_ENTRY4_SIZE}).testEquals();
    }

    @Test
    public void testClose() throws IOException {
        MapDBLog log = new MapDBLog(this.dbFileName, SERIALIZER);
        Assert.assertFalse((boolean)log.isOpen());
        log.open();
        Assert.assertTrue((boolean)log.isOpen());
        log.close();
        Assert.assertFalse((boolean)log.isOpen());
    }

    @Test
    public void testReopen() throws IOException {
        MapDBLog log = new MapDBLog(this.dbFileName, SERIALIZER);
        log.open();
        log.appendEntries(new Entry[]{TEST_ENTRY1, TEST_ENTRY2, TEST_ENTRY3, TEST_ENTRY4});
        log.close();
        log.open();
        new EqualsTester().addEqualityGroup(new Object[]{log.firstEntry(), TEST_ENTRY1}).addEqualityGroup(new Object[]{log.getEntry(2L), TEST_ENTRY2}).addEqualityGroup(new Object[]{log.lastEntry(), TEST_ENTRY4}).addEqualityGroup(new Object[]{log.size(), TEST_ENTRY1_SIZE + TEST_ENTRY2_SIZE + TEST_ENTRY3_SIZE + TEST_ENTRY4_SIZE}).testEquals();
    }

    @Test
    public void testCompact() throws IOException {
        MapDBLog log = new MapDBLog(this.dbFileName, SERIALIZER);
        log.open();
        log.appendEntries(new Entry[]{TEST_ENTRY1, TEST_ENTRY2, TEST_ENTRY3, TEST_ENTRY4});
        log.compact(3L, TEST_SNAPSHOT_ENTRY);
        new EqualsTester().addEqualityGroup(new Object[]{log.firstEntry(), TEST_SNAPSHOT_ENTRY}).addEqualityGroup(new Object[]{log.lastEntry(), TEST_ENTRY4}).addEqualityGroup(new Object[]{log.size(), TEST_SNAPSHOT_ENTRY_SIZE + TEST_ENTRY4_SIZE}).testEquals();
    }
}

